/*
 * Decompiled with CFR 0.152.
 */
package de.renew.plugin.command;

import de.renew.plugin.IPlugin;
import de.renew.plugin.PluginManager;
import de.renew.plugin.command.CLCommand;
import de.renew.plugin.command.InfoCommand;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Logger;

public class ListCommand
implements CLCommand {
    public static Logger logger = Logger.getLogger(InfoCommand.class);

    @Override
    public void execute(String[] stringArray, PrintStream printStream) {
        DefaultParser defaultParser = new DefaultParser();
        Options options = new Options();
        Option option = new Option("o", "ordered", false, "Print ordered list.");
        options.addOption(option);
        Option option2 = new Option("l", "long", false, "Display more information about every plugin.");
        options.addOption(option2);
        Option option3 = new Option("j", "jar", false, "List locations of all jar files.");
        options.addOption(option3);
        Option option4 = new Option("h", "help", false, "Print this message.");
        options.addOption(option4);
        CommandLine commandLine = null;
        try {
            commandLine = defaultParser.parse(options, stringArray);
        }
        catch (ParseException parseException) {
            HelpFormatter helpFormatter = new HelpFormatter();
            PrintWriter printWriter = new PrintWriter(printStream, true);
            helpFormatter.printHelp(printWriter, helpFormatter.getWidth(), "list", null, options, helpFormatter.getLeftPadding(), helpFormatter.getDescPadding(), null, true);
            return;
        }
        if (commandLine.hasOption(option4.getOpt())) {
            HelpFormatter helpFormatter = new HelpFormatter();
            helpFormatter.setArgName("Plugin Name Fragment");
            String string = "List loaded Renew plugins.";
            String string2 = "Plugin name fragment can be any part of the plugin name.\nPlease, escape white spaces.";
            PrintWriter printWriter = new PrintWriter(printStream, true);
            helpFormatter.printHelp(printWriter, helpFormatter.getWidth(), "list [options] [plugin name fragment]", string, options, helpFormatter.getLeftPadding(), helpFormatter.getDescPadding(), string2, true);
            return;
        }
        String string = null;
        if (commandLine.getArgs() != null && commandLine.getArgs().length > 0) {
            string = commandLine.getArgs()[0];
        }
        if (commandLine.hasOption(option3.getOpt())) {
            URL[] uRLArray;
            Iterator<IPlugin> iterator = PluginManager.getInstance().getPlugins().iterator();
            printStream.println("Plugin JAR-file locations:");
            while (iterator.hasNext()) {
                uRLArray = iterator.next();
                if (this.skip((IPlugin)uRLArray, string)) continue;
                printStream.println(uRLArray.getProperties().getURL());
            }
            printStream.println("Libraries JAR-file locations:");
            for (URL uRL : uRLArray = PluginManager.getInstance().getLibs()) {
                printStream.println(uRL);
            }
            return;
        }
        List<IPlugin> list = PluginManager.getInstance().getPlugins();
        if (commandLine.hasOption(option.getOpt())) {
            Collections.sort(list, new PluginNameComparator());
        }
        if (commandLine.hasOption(option2.getOpt())) {
            try {
                for (IPlugin iPlugin : list) {
                    if (this.skip(iPlugin, string)) continue;
                    String string3 = "";
                    string3 = iPlugin.getVersion();
                    printStream.println(iPlugin.getProperties().getFilteredProperty(".date") + "\t " + iPlugin.getProperties().getFilteredProperty(".user") + "\t " + string3 + "\t " + iPlugin.getName());
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            }
            catch (NumberFormatException numberFormatException) {
                printStream.println("cleanup canceled.");
            }
            catch (Exception exception) {
                printStream.println("cleanup canceled: " + String.valueOf(exception) + "; " + exception.getMessage());
                logger.error((Object)exception.getMessage(), (Throwable)exception);
            }
            return;
        }
        for (IPlugin iPlugin : list) {
            if (this.skip(iPlugin, string)) continue;
            printStream.println(iPlugin);
        }
    }

    private boolean skip(IPlugin iPlugin, String string) {
        if (string == null || string.trim().length() == 0) {
            return false;
        }
        String string2 = string.trim().toLowerCase();
        if (iPlugin.getName() != null && iPlugin.getName().toLowerCase().contains(string2)) {
            return false;
        }
        return iPlugin.getAlias() == null || !iPlugin.getAlias().toLowerCase().contains(string2);
    }

    @Override
    public String getDescription() {
        return "lists all loaded plugins. Options: [-l| --long] for more information; [-c| --comment] to show compile comments; [-j|--jar] to show all JAR file locations;[-o] to show ordered list.";
    }

    @Override
    public String getArguments() {
        return "(--ordered|--long|--jar|--help) (--ordered|--long)";
    }

    public class PluginNameComparator
    implements Comparator<IPlugin> {
        @Override
        public int compare(IPlugin iPlugin, IPlugin iPlugin2) {
            String string = iPlugin.getName();
            String string2 = iPlugin2.getName();
            return string.compareTo(string2);
        }
    }
}

