/*
 * Decompiled with CFR 0.152.
 */
package de.renew.mxml;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class MXMLCommandCenter {
    private boolean state = false;
    private String userName = "";
    public static final String PROCESS_SEP = "`";
    public static final String AUDIT_TRAIL_SEP = "\u00a7";
    public static final String PROCESS_INST_SEP = "\u00b5";
    public static final String DATA_SEP = "%";
    public static final String ATRIBUTE_SEP = "&";
    public static final int PROCESS = 1;
    public static final int PROCESS_INSTANCE = 2;
    public static final int AUDIT_TRAIL = 3;
    private static String separatorErrorMessage = "ERROR: one of the parameter is either null or contains one of the reserved symbols \"\u00a7, %, &, `, \u00b5\" in:";
    public static final String LOGGER = "de.renew.mxml.mxmllogger";
    public static final String FILE = System.getProperty("user.home") + File.separator + "renewlogs" + File.separator + "WorkflowLog.txt";
    public static final String FATAL = "F";
    private static boolean lock = false;

    private MXMLCommandCenter() {
    }

    public static MXMLCommandCenter getInstance() {
        return MXMLHolder.INSTANCE;
    }

    public boolean isOn() {
        return this.state;
    }

    public void changeState(boolean bl) {
        if (!MXMLCommandCenter.isLocked()) {
            this.state = bl;
        }
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String string) {
        this.userName = string;
    }

    public static String setNumberOfAttributes(int n) {
        return "" + n;
    }

    public static String setAttribute(String string, String string2, boolean bl, boolean bl2) {
        Object object = "";
        if (MXMLCommandCenter.containsSeparator(string) || MXMLCommandCenter.containsSeparator(string2)) {
            System.err.println(separatorErrorMessage);
            new Throwable().printStackTrace();
        } else {
            if (bl) {
                object = AUDIT_TRAIL_SEP;
            }
            object = (String)object + string + ATRIBUTE_SEP + string2;
            if (!bl2) {
                object = (String)object + DATA_SEP;
            }
        }
        return object;
    }

    public static String setProcessInsAttribute(String string, String string2, boolean bl, boolean bl2) {
        Object object = "";
        if (MXMLCommandCenter.containsSeparator(string) || MXMLCommandCenter.containsSeparator(string2)) {
            System.err.println(separatorErrorMessage);
            new Throwable().printStackTrace();
        } else {
            if (bl) {
                object = PROCESS_INST_SEP;
            }
            object = (String)object + string + ATRIBUTE_SEP + string2;
            if (!bl2) {
                object = (String)object + DATA_SEP;
            }
        }
        return object;
    }

    public static String setOwnAuditTrail(String string, String string2) {
        Object object = "";
        if (MXMLCommandCenter.containsSeparator(string) || MXMLCommandCenter.containsSeparator(string2)) {
            System.err.println(separatorErrorMessage);
            new Throwable().printStackTrace();
        } else {
            object = (String)object + AUDIT_TRAIL_SEP + string + AUDIT_TRAIL_SEP + string2;
        }
        return object;
    }

    public static String setOwnProcessInstance(String string) {
        Object object = "";
        if (MXMLCommandCenter.containsSeparator(string)) {
            System.err.println(separatorErrorMessage);
            new Throwable().printStackTrace();
        } else {
            int n = 0;
            for (int i = 0; i < string.length(); ++i) {
                n += string.charAt(i);
            }
            object = (String)object + PROCESS_INST_SEP + (n += 1000) + PROCESS_INST_SEP + string;
        }
        return object;
    }

    public static String setOwnProcess(String string) {
        Object object = "";
        if (MXMLCommandCenter.containsSeparator(string)) {
            System.err.println(separatorErrorMessage);
            new Throwable().printStackTrace();
        } else {
            int n = 0;
            for (int i = 0; i < string.length(); ++i) {
                n += string.charAt(i);
            }
            object = PROCESS_SEP + (n += 1000) + PROCESS_SEP + string;
        }
        return object;
    }

    public static boolean isLocked() {
        return lock;
    }

    public static void lockEnvironment() {
        lock = true;
        MXMLCommandCenter.getInstance().changeState(false);
        MXMLCommandCenter.getInstance().changeState(false);
        Logger logger = Logger.getLogger(MXMLCommandCenter.class);
        logger.setLevel(Level.FATAL);
        logger.fatal((Object)"Cannot log event, MXML log file has been deleted. Restart the application to continue logging.\n The MXMLLoggin mechanism has been severely destabilized and has been shut down");
        logger.setLevel(Level.DEBUG);
    }

    public String closeDocument() {
        BufferedReader bufferedReader = null;
        BufferedWriter bufferedWriter = null;
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyMMddHHmmssZ");
        try {
            bufferedReader = new BufferedReader(new FileReader(FILE));
            String string = bufferedReader.readLine();
            if (string == null || string.equals("")) {
                System.out.println("INFO: Log file empty");
                bufferedReader.close();
                return "";
            }
            String string2 = System.getProperty("user.home") + File.separator + "renewlogs" + File.separator + "WorkflowLog" + simpleDateFormat.format(date) + ".mxml";
            bufferedWriter = new BufferedWriter(new FileWriter(string2));
            bufferedWriter.write(string);
            while ((string = bufferedReader.readLine()) != null) {
                bufferedWriter.write(string);
            }
            bufferedWriter.write("</ProcessInstance></Process></WorkflowLog>");
            System.out.println("INFO: MXML log file succesfully saved as " + string2);
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            if (bufferedWriter != null) {
                bufferedWriter.close();
            }
            return string2;
        }
        catch (IOException iOException) {
            MXMLCommandCenter.lockEnvironment();
            return FATAL;
        }
    }

    public static String formatConstant(String string, String string2, int n) {
        Object object = "";
        if (!MXMLCommandCenter.containsSeparator(string) && !MXMLCommandCenter.containsSeparator(string2)) {
            if (n == 3) {
                object = AUDIT_TRAIL_SEP + string + AUDIT_TRAIL_SEP + string2;
            } else if (n == 2) {
                object = PROCESS_INST_SEP + string2 + PROCESS_INST_SEP + string;
            } else if (n == 1) {
                object = PROCESS_SEP + string2 + PROCESS_SEP + string;
            } else {
                System.err.println("ERROR: unspecified layer at parameter");
                new Throwable().printStackTrace();
            }
        } else {
            System.err.println(separatorErrorMessage);
            new Throwable().printStackTrace();
        }
        return object;
    }

    private static boolean containsSeparator(String string) {
        return string == null || string.equals("") || string.contains(PROCESS_INST_SEP) || string.contains(AUDIT_TRAIL_SEP) || string.contains(DATA_SEP) || string.contains(ATRIBUTE_SEP) || string.contains(PROCESS_SEP);
    }

    private static class MXMLHolder {
        public static final MXMLCommandCenter INSTANCE = new MXMLCommandCenter();

        private MXMLHolder() {
        }
    }
}

