/*
 * Decompiled with CFR 0.152.
 */
package de.renew.navigator.io;

import CH.ifa.draw.io.CombinationFileFilter;
import de.renew.navigator.io.FileFilterBuilder;
import de.renew.navigator.io.IOLoader;
import de.renew.navigator.io.ProgressListener;
import de.renew.navigator.models.Directory;
import de.renew.navigator.models.DirectoryType;
import de.renew.navigator.models.Leaf;
import de.renew.navigator.models.NavigatorFileTree;
import de.renew.navigator.models.TreeElement;
import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public class FilesystemIOLoader
implements IOLoader {
    private final FileFilterBuilder fileFilterBuilder;
    private static Logger logger = Logger.getLogger(FilesystemIOLoader.class);

    public FilesystemIOLoader(FileFilterBuilder fileFilterBuilder) {
        this.fileFilterBuilder = fileFilterBuilder;
    }

    @Override
    public TreeElement loadPath(File file, ProgressListener progressListener) {
        TreeElement treeElement = this.createModel(file);
        if (treeElement instanceof Directory) {
            CombinationFileFilter combinationFileFilter = this.fileFilterBuilder.buildFileFilter();
            Directory directory = (Directory)treeElement;
            this.classifyDirectory(directory, (FileFilter)combinationFileFilter);
            directory.setOpened(true);
            this.loadDirectory(directory, progressListener, (FileFilter)combinationFileFilter);
        }
        return treeElement;
    }

    @Override
    public void refreshPath(TreeElement treeElement, File file, ProgressListener progressListener) {
        if (treeElement instanceof Directory) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("refreshing path: " + String.valueOf(file)));
            }
            Directory directory = (Directory)this.loadPath(file, progressListener);
            this.compareDirectories((Directory)treeElement, directory, progressListener);
        }
    }

    private void loadDirectory(Directory directory, final ProgressListener progressListener, FileFilter fileFilter) {
        if (progressListener.isWorkerCancelled()) {
            return;
        }
        File[] fileArray = this.listDirectoryContents(directory, fileFilter);
        if (fileArray == null) {
            return;
        }
        final int n = fileArray.length;
        int n2 = 0;
        this.sortFiles(fileArray);
        for (File file : fileArray) {
            Object object;
            TreeElement treeElement;
            if (!file.isDirectory() && file.isFile()) {
                treeElement = this.createFileModel(file);
                directory.add(treeElement);
                progressListener.progress(++n2, n);
                continue;
            }
            treeElement = this.createDirectoryModel(file);
            directory.add(treeElement);
            this.classifyDirectory((Directory)treeElement, fileFilter);
            if (((Directory)treeElement).getType() == DirectoryType.PACKAGE) {
                File[] fileArray2 = file.listFiles(fileFilter);
                while (fileArray2 != null && fileArray2.length == 1 && fileArray2[0].isDirectory()) {
                    file = fileArray2[0];
                    treeElement.setFile(file);
                    object = treeElement.getName() + "." + file.getName();
                    treeElement.setName((String)object);
                    fileArray2 = file.listFiles(fileFilter);
                }
            }
            final int n3 = n2++;
            object = new ProgressListener(){

                @Override
                public void progress(float f, int n2) {
                    progressListener.progress((float)n3 + f / (float)n2, n);
                }

                @Override
                public boolean isWorkerCancelled() {
                    return progressListener.isWorkerCancelled();
                }
            };
            this.loadDirectory((Directory)treeElement, (ProgressListener)object, fileFilter);
            progressListener.progress(n2, n);
        }
    }

    private void sortFiles(File[] fileArray) {
        Arrays.sort(fileArray, new Comparator<File>(){

            @Override
            public int compare(File file, File file2) {
                if (file.isDirectory() && !file2.isDirectory()) {
                    return -1;
                }
                if (!file.isDirectory() && file2.isDirectory()) {
                    return 1;
                }
                return file.getName().compareToIgnoreCase(file2.getName());
            }
        });
    }

    private void compareDirectories(Directory directory, Directory directory2, ProgressListener progressListener) {
        if (progressListener.isWorkerCancelled()) {
            return;
        }
        logger.debug((Object)("Comparing " + directory.getFile().getAbsolutePath()));
        LinkedList<TreeElement> linkedList = new LinkedList<TreeElement>();
        for (TreeElement treeElement : directory.getChildren()) {
            TreeElement treeElement2 = this.findNewTreeElement(directory2, treeElement);
            if (treeElement2 == null) {
                linkedList.add(treeElement);
                continue;
            }
            directory2.remove(treeElement2);
            if (treeElement instanceof Leaf) {
                if (treeElement2 instanceof Leaf) continue;
                linkedList.add(treeElement);
                directory.add(treeElement2);
                continue;
            }
            if (!(treeElement instanceof Directory)) continue;
            if (treeElement2 instanceof Directory) {
                this.compareDirectories((Directory)treeElement, (Directory)treeElement2, progressListener);
                continue;
            }
            linkedList.add(treeElement);
            directory.add(treeElement2);
        }
        for (TreeElement treeElement : directory2.getChildren()) {
            logger.debug((Object)("New Child: " + String.valueOf(treeElement)));
            directory.add(treeElement);
        }
        for (TreeElement treeElement : linkedList) {
            logger.debug((Object)("Removed Child: " + String.valueOf(treeElement)));
            directory.remove(treeElement);
        }
    }

    private TreeElement findNewTreeElement(Directory directory, TreeElement treeElement) {
        TreeElement treeElement2 = null;
        for (TreeElement treeElement3 : directory.getChildren()) {
            if (!treeElement.getFile().equals(treeElement3.getFile())) continue;
            treeElement2 = treeElement3;
        }
        return treeElement2;
    }

    private TreeElement createModel(File file) {
        if (file.isDirectory()) {
            return this.createDirectoryModel(file);
        }
        return this.createFileModel(file);
    }

    private Directory createDirectoryModel(File file) {
        Directory directory = new Directory();
        directory.setOpened(false);
        directory.setFile(file);
        directory.setName(file.getName());
        directory.setExcluded(false);
        return directory;
    }

    private Leaf createFileModel(File file) {
        Leaf leaf = new Leaf();
        leaf.setFile(file);
        leaf.setName(file.getName());
        leaf.setExcluded(false);
        return leaf;
    }

    private void classifyDirectory(Directory directory, FileFilter fileFilter) {
        DirectoryType directoryType = directory.getParent() == null || directory.getParent() instanceof NavigatorFileTree ? null : ((Directory)directory.getParent()).getType();
        if (directoryType == DirectoryType.SOURCE || directoryType == DirectoryType.PACKAGE || directoryType == DirectoryType.TEST_SOURCE) {
            directory.setType(DirectoryType.PACKAGE);
            return;
        }
        if (directoryType == DirectoryType.PLUGIN) {
            String string = directory.getFile().getName();
            if (string.equals("src") || string.equals("resources")) {
                directory.setType(DirectoryType.SOURCE);
                return;
            }
            if (string.equals("test") || string.equals("testsrc") || string.equals("testing")) {
                directory.setType(DirectoryType.TEST_SOURCE);
                return;
            }
            if (string.equals("etc")) {
                directory.setType(DirectoryType.ETC);
                return;
            }
            return;
        }
        File[] fileArray = this.listDirectoryContents(directory, fileFilter);
        if (directoryType == null && this.containsPluginDirs(fileArray)) {
            directory.setType(DirectoryType.PLUGIN);
        }
    }

    private boolean containsPluginDirs(File[] fileArray) {
        if (fileArray == null) {
            return false;
        }
        for (File file : fileArray) {
            if (!file.isDirectory() || !file.getName().equals("etc")) continue;
            File[] fileArray2 = file.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.getName().equals("plugin.cfg");
                }
            });
            return fileArray2 != null && fileArray2.length > 0;
        }
        return false;
    }

    private File[] listDirectoryContents(Directory directory, FileFilter fileFilter) {
        File file = directory.getFile();
        return file.listFiles(fileFilter);
    }
}

