/*
 * Decompiled with CFR 0.152.
 */
package de.renew.navigator;

import de.renew.navigator.NavigatorController;
import de.renew.navigator.NavigatorPlugin;
import de.renew.navigator.io.FileFilterBuilder;
import de.renew.navigator.io.FilesystemIOLoader;
import de.renew.navigator.io.IOLoader;
import de.renew.navigator.io.ProgressListener;
import de.renew.navigator.models.BackgroundTask;
import de.renew.navigator.models.TreeElement;
import de.renew.plugin.IPlugin;
import de.renew.plugin.PluginManager;
import de.renew.plugin.PluginProperties;
import de.renew.util.PathEntry;
import de.renew.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingWorker;
import javax.swing.filechooser.FileFilter;

public class FilesystemController
extends NavigatorController {
    public static final String FILES_AT_STARTUP = "de.renew.navigator.filesAtStartup";
    public static final String WORKSPACE_LOCATION = "de.renew.navigator.workspace";
    public static final String NET_PATH = "de.renew.netPath";
    private final IOLoader ioLoader;
    private final FileFilterBuilder fileFilterBuilder;
    private final HashSet<SwingWorker<TreeElement, Void>> activeWorkers;

    public FilesystemController(NavigatorPlugin navigatorPlugin, FileFilterBuilder fileFilterBuilder) {
        super(navigatorPlugin);
        this.fileFilterBuilder = fileFilterBuilder;
        this.ioLoader = new FilesystemIOLoader(fileFilterBuilder);
        this.activeWorkers = new HashSet();
    }

    public boolean isExternallyOpenedFile(File file) {
        return this.fileFilterBuilder.isExternallyOpenedFile(file);
    }

    public void loadRootDirectories(Collection<File> collection) {
        for (final File file : collection) {
            this.addLoadingTask(new LoadingTask(){

                @Override
                public String getName() {
                    return String.format("Loading %s ...", file.getName());
                }

                @Override
                public TreeElement performAction(ProgressListener progressListener) {
                    return FilesystemController.this.ioLoader.loadPath(file, progressListener);
                }
            });
        }
    }

    public void loadFromProperties() {
        this.cancelAllLoadingTasks();
        this.model.clear();
        PluginProperties pluginProperties = this.plugin.getProperties();
        String string = pluginProperties.getProperty(WORKSPACE_LOCATION, System.getProperty("user.dir"));
        File file = new File(string);
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            file = new File(System.getProperty("user.dir"));
        }
        String string2 = pluginProperties.getProperty(FILES_AT_STARTUP, ".");
        LinkedList<File> linkedList = new LinkedList<File>();
        for (String string3 : string2.split(";")) {
            File file2 = new File(string3);
            if (!file2.isAbsolute()) {
                file2 = new File(file, string3);
            }
            try {
                file2 = file2.getCanonicalFile();
                if (!file2.exists() || !file2.isDirectory()) continue;
                linkedList.add(file2);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.loadRootDirectories(linkedList);
    }

    public void loadFromNetPaths() {
        IPlugin iPlugin = PluginManager.getInstance().getPluginByName("Renew Simulator");
        if (iPlugin == null) {
            throw new RuntimeException("Could not find Simulator plugin.");
        }
        String string = iPlugin.getProperties().getProperty(NET_PATH);
        if (string == null) {
            throw new RuntimeException("Net path property is not set.");
        }
        String[] stringArray = StringUtil.splitPaths((String)string);
        PathEntry[] pathEntryArray = StringUtil.canonizePaths((String[])stringArray);
        LinkedList<File> linkedList = new LinkedList<File>();
        for (PathEntry pathEntry : pathEntryArray) {
            if (pathEntry.isClasspathRelative) continue;
            linkedList.add(new File(pathEntry.path));
        }
        this.loadRootDirectories(linkedList);
    }

    public void refreshPaths() {
        this.cancelAllLoadingTasks();
        for (final TreeElement treeElement : this.model.getTreeRoots()) {
            this.addLoadingTask(new LoadingTask(){

                @Override
                public String getName() {
                    return String.format("Refreshing %s ...", treeElement.getName());
                }

                @Override
                public TreeElement performAction(ProgressListener progressListener) {
                    FilesystemController.this.ioLoader.refreshPath(treeElement, treeElement.getFile(), progressListener);
                    return treeElement;
                }
            });
        }
    }

    public FileFilter getFileFilter() {
        return this.fileFilterBuilder.buildFileFilter();
    }

    private void addLoadingTask(final LoadingTask loadingTask) {
        final FilesystemController filesystemController = this;
        final BackgroundTask backgroundTask = new BackgroundTask(loadingTask.getName());
        final SwingWorker<TreeElement, Void> swingWorker = new SwingWorker<TreeElement, Void>(){

            @Override
            protected TreeElement doInBackground() throws Exception {
                ProgressListener progressListener = new ProgressListener(){

                    @Override
                    public void progress(float f, int n) {
                        backgroundTask.setCurrent(f / (float)n);
                        backgroundTask.notifyObservers();
                    }

                    @Override
                    public boolean isWorkerCancelled() {
                        return this.isCancelled();
                    }
                };
                return loadingTask.performAction(progressListener);
            }

            @Override
            protected void done() {
                FilesystemController.this.model.removeBackgroundTask(backgroundTask);
                if (!this.isCancelled()) {
                    FilesystemController.this.activeWorkers.remove(this);
                    try {
                        TreeElement treeElement = (TreeElement)this.get();
                        if (!FilesystemController.this.model.contains(treeElement)) {
                            FilesystemController.this.model.add(treeElement);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                    catch (ExecutionException executionException) {
                        executionException.printStackTrace();
                    }
                }
                FilesystemController.this.model.notifyObservers(filesystemController);
            }
        };
        this.activeWorkers.add(swingWorker);
        swingWorker.execute();
        backgroundTask.setCancelAction(new Runnable(){

            @Override
            public void run() {
                FilesystemController.this.activeWorkers.remove(swingWorker);
                swingWorker.cancel(true);
            }
        });
        this.model.addBackgroundTask(backgroundTask);
        this.model.notifyObservers(this);
    }

    private void cancelAllLoadingTasks() {
        Iterator<SwingWorker<TreeElement, Void>> iterator = this.activeWorkers.iterator();
        while (iterator.hasNext()) {
            SwingWorker<TreeElement, Void> swingWorker = iterator.next();
            iterator.remove();
            swingWorker.cancel(true);
        }
    }

    static interface LoadingTask {
        public String getName();

        public TreeElement performAction(ProgressListener var1);
    }
}

