/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui.logging;

import de.renew.application.SimulatorPlugin;
import de.renew.engine.common.SimulatorEvent;
import de.renew.engine.common.StepIdentifier;
import de.renew.gui.logging.MainRepository;
import de.renew.gui.logging.StepTraceRepository;
import java.util.HashSet;
import java.util.Vector;
import org.apache.log4j.Logger;

public class MainRepositoryManager {
    private static Logger logger = Logger.getLogger(MainRepositoryManager.class);
    private static MainRepositoryManager manager = null;
    private LongHashSet[] simulationRunIds;
    private MainRepository[] repositories;
    private static int defaultSimulationHistoriesDim = 2;

    public MainRepositoryManager() {
        this(defaultSimulationHistoriesDim);
    }

    public MainRepositoryManager(int n) {
        this.simulationRunIds = new LongHashSet[n];
        this.repositories = new MainRepository[this.simulationRunIds.length];
    }

    public static MainRepositoryManager getInstance() {
        if (manager == null) {
            manager = new MainRepositoryManager();
        }
        return manager;
    }

    public long[] getSimulationRunIds() {
        int n;
        Vector<Long> vector = new Vector<Long>();
        for (n = 0; n < this.simulationRunIds.length && this.repositories[n] != null; ++n) {
            vector.addAll(this.simulationRunIds[n]);
        }
        long[] lArray = new long[vector.size()];
        for (n = 0; n < vector.size(); ++n) {
            lArray[n] = (Long)vector.get(n);
        }
        return lArray;
    }

    public MainRepository getRepository(long l) {
        long[] lArray;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)(MainRepositoryManager.class.getSimpleName() + " fetching main repo for runId: " + l));
        }
        for (int i = 0; i < this.repositories.length && this.repositories[i] != null; ++i) {
            if (!this.simulationRunIds[i].contains(l)) continue;
            return this.repositories[i];
        }
        try {
            lArray = SimulatorPlugin.getCurrent().getCurrentEnvironment().getSimulator().collectSimulationRunIds();
        }
        catch (NullPointerException nullPointerException) {
            logger.warn((Object)(MainRepositoryManager.class.getSimpleName() + ": Could not determine the simulation the run id " + l + " belongs to."));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(MainRepositoryManager.class.getSimpleName() + ": " + String.valueOf(nullPointerException)));
            }
            lArray = new long[]{l};
        }
        LongHashSet longHashSet = new LongHashSet(lArray);
        if (!longHashSet.contains(l)) {
            logger.warn((Object)(MainRepositoryManager.class.getSimpleName() + ": The run id " + l + " does not belong to the current simulation."));
            lArray = new long[]{l};
            longHashSet = new LongHashSet(lArray);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(MainRepositoryManager.class.getSimpleName() + ": Creating new repository covering run ids " + String.valueOf(longHashSet)));
        }
        MainRepository mainRepository = new MainRepository();
        for (int i = this.repositories.length - 1; i > 0; --i) {
            this.simulationRunIds[i] = this.simulationRunIds[i - 1];
            this.repositories[i] = this.repositories[i - 1];
        }
        this.simulationRunIds[0] = longHashSet;
        this.repositories[0] = mainRepository;
        return mainRepository;
    }

    public MainRepository getRepository(SimulatorEvent simulatorEvent) {
        StepIdentifier stepIdentifier = simulatorEvent.getStep();
        if (stepIdentifier != null) {
            long l = stepIdentifier.getSimulationRunId();
            return this.getRepository(l);
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)(MainRepositoryManager.class.getSimpleName() + " found no main repo for: " + String.valueOf(simulatorEvent)));
        }
        return null;
    }

    public StepTraceRepository getCurrentRepository(String string) {
        long l = SimulatorPlugin.getCurrent().getCurrentEnvironment().getSimulator().currentStepIdentifier().getSimulationRunId();
        return this.getRepository(l).getLoggerRepository(string, -1);
    }

    private static class LongHashSet
    extends HashSet<Long> {
        public LongHashSet(int n) {
            super(n);
        }

        public LongHashSet(long[] lArray) {
            this(lArray.length);
            for (long l : lArray) {
                this.add(l);
            }
        }
    }
}

