/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui.logging;

import de.renew.gui.logging.AppenderBuilder;
import de.renew.gui.logging.LoggingGuiPlugin;
import de.renew.plugin.PluginProperties;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import org.apache.log4j.Appender;
import org.apache.log4j.Logger;

public class AppenderFactory {
    private static final Logger logger = Logger.getLogger(AppenderFactory.class);
    private static final String APPENDER_TYPE_PREFIX = "appender.type.";
    private static final String APPENDER_TYPE_CLASS = "class";
    private static final String APPENDER_TYPE_BUILDER = "builder";
    private static AppenderFactory factory = null;
    private Map<String, AppenderBuilder> builders = new Hashtable<String, AppenderBuilder>();

    private AppenderFactory() {
        PluginProperties pluginProperties = LoggingGuiPlugin.getCurrent().getProperties();
        Enumeration<Object> enumeration = pluginProperties.keys();
        while (enumeration.hasMoreElements()) {
            Object object;
            String string = (String)enumeration.nextElement();
            if (!string.startsWith(APPENDER_TYPE_PREFIX) || string.length() <= APPENDER_TYPE_PREFIX.length()) continue;
            String string2 = string.substring(APPENDER_TYPE_PREFIX.length());
            if (string2.indexOf(".") >= 0) {
                string2 = string2.substring(0, string2.indexOf("."));
            }
            if (this.builders.containsKey(string2)) continue;
            String string3 = pluginProperties.getProperty(APPENDER_TYPE_PREFIX + string2 + ".builder");
            AppenderBuilder appenderBuilder = null;
            if (string3 != null) {
                try {
                    object = this.getClass().getClassLoader().loadClass(string3);
                    appenderBuilder = (AppenderBuilder)((Class)object).newInstance();
                }
                catch (Exception exception) {
                    logger.error((Object)("Can't load instance of builder class for appender type " + string2));
                    logger.error((Object)exception.getMessage(), (Throwable)exception);
                }
            }
            if (appenderBuilder == null && (object = pluginProperties.getProperty(APPENDER_TYPE_PREFIX + string2 + ".class")) != null) {
                try {
                    appenderBuilder = new DefaultAppenderBuilder((String)object);
                }
                catch (Exception exception) {
                    logger.error((Object)exception.getMessage(), (Throwable)exception);
                }
            }
            if (appenderBuilder == null || this.builders.containsKey(string2)) continue;
            this.builders.put(string2, appenderBuilder);
        }
    }

    public static AppenderFactory getInstance() {
        if (factory == null) {
            factory = new AppenderFactory();
        }
        return factory;
    }

    public Appender createNewAppender(String string) throws InstantiationException {
        Appender appender = null;
        AppenderBuilder appenderBuilder = this.builders.get(string);
        if (appenderBuilder != null) {
            appender = appenderBuilder.newInstance();
        }
        return appender;
    }

    public String[] getAllAppenderTypes() {
        return this.builders.keySet().toArray(new String[0]);
    }

    private class DefaultAppenderBuilder
    implements AppenderBuilder {
        private final Class<?> clazz;

        protected DefaultAppenderBuilder(String string) throws ClassNotFoundException {
            this.getClass();
            this.clazz = Class.forName(string);
        }

        @Override
        public Appender newInstance() throws InstantiationException {
            try {
                return (Appender)this.clazz.newInstance();
            }
            catch (InstantiationException instantiationException) {
                throw instantiationException;
            }
            catch (Exception exception) {
                throw new InstantiationException();
            }
        }
    }
}

