/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui.logging;

import de.renew.gui.logging.RepositoryChangeListener;
import de.renew.gui.logging.StepTrace;
import de.renew.gui.logging.StepTraceRemoveRequest;
import de.renew.gui.logging.StepTraceRepository;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractRepository
implements StepTraceRepository {
    protected Set<RepositoryChangeListener> listeners = new HashSet<RepositoryChangeListener>();

    @Override
    public void addRepositoryChangeListener(RepositoryChangeListener repositoryChangeListener) {
        this.listeners.add(repositoryChangeListener);
    }

    @Override
    public void removeRepositoryChangeListener(RepositoryChangeListener repositoryChangeListener) {
        this.listeners.remove(repositoryChangeListener);
    }

    protected void fireStepTraceChanged(StepTrace stepTrace) {
        RepositoryChangeListener[] repositoryChangeListenerArray = this.listeners.toArray(new RepositoryChangeListener[0]);
        for (int i = 0; i < repositoryChangeListenerArray.length; ++i) {
            repositoryChangeListenerArray[i].stepTraceChanged(stepTrace);
        }
    }

    protected void fireStepTraceAdded(StepTrace stepTrace) {
        RepositoryChangeListener[] repositoryChangeListenerArray = this.listeners.toArray(new RepositoryChangeListener[0]);
        for (int i = 0; i < repositoryChangeListenerArray.length; ++i) {
            repositoryChangeListenerArray[i].stepTraceAdded(null, stepTrace);
        }
    }

    protected void fireStepTraceRemoved(StepTrace stepTrace) {
        RepositoryChangeListener[] repositoryChangeListenerArray = this.listeners.toArray(new RepositoryChangeListener[0]);
        for (int i = 0; i < repositoryChangeListenerArray.length; ++i) {
            repositoryChangeListenerArray[i].stepTraceRemoved(null, stepTrace);
        }
    }

    protected boolean fireStepTraceRemoveRequest(StepTrace stepTrace) {
        boolean bl = false;
        StepTraceRemoveRequest stepTraceRemoveRequest = new StepTraceRemoveRequest(this, stepTrace);
        RepositoryChangeListener[] repositoryChangeListenerArray = this.listeners.toArray(new RepositoryChangeListener[0]);
        for (int i = 0; i < repositoryChangeListenerArray.length && !bl; ++i) {
            repositoryChangeListenerArray[i].stepTraceRemoveRequest(stepTraceRemoveRequest);
            bl = stepTraceRemoveRequest.hasVeto();
        }
        return bl;
    }
}

