/*
 * Decompiled with CFR 0.152.
 */
package de.renew.refactoring.renamechannel;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import de.renew.gui.CPNTextFigure;
import de.renew.gui.DeclarationFigure;
import de.renew.refactoring.match.DownlinkMatch;
import de.renew.refactoring.match.LinkMatch;
import de.renew.refactoring.match.StringMatch;
import de.renew.refactoring.match.UplinkMatch;
import de.renew.refactoring.parse.LinkParser;
import de.renew.refactoring.search.DrawingSearcher;
import de.renew.refactoring.search.range.DrawingSearchRange;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

class RenameChannelReferencingLinkFinder
extends DrawingSearcher<LinkMatch> {
    private static Logger logger = Logger.getLogger(RenameChannelReferencingLinkFinder.class);
    private final LinkParser _parser;
    private final String _channel;
    private final int _parameterCount;

    RenameChannelReferencingLinkFinder(LinkParser linkParser, String string, int n, DrawingSearchRange drawingSearchRange) {
        super(drawingSearchRange);
        this._parser = linkParser;
        this._channel = string;
        this._parameterCount = n;
    }

    @Override
    public List<LinkMatch> searchDrawing(Drawing drawing) {
        ArrayList<LinkMatch> arrayList = new ArrayList<LinkMatch>();
        FigureEnumeration figureEnumeration = drawing.figures();
        while (figureEnumeration.hasMoreElements()) {
            Figure figure = figureEnumeration.nextFigure();
            if (!(figure instanceof CPNTextFigure) || figure instanceof DeclarationFigure) continue;
            CPNTextFigure cPNTextFigure = (CPNTextFigure)figure;
            UplinkMatch uplinkMatch = this.findUplink(cPNTextFigure, drawing);
            if (uplinkMatch != null) {
                arrayList.add(uplinkMatch);
            }
            arrayList.addAll(this.findDownlinks(cPNTextFigure, drawing));
        }
        logger.debug((Object)("Found " + arrayList.size() + " referencing links in drawing " + drawing.getName()));
        return arrayList;
    }

    private UplinkMatch findUplink(CPNTextFigure cPNTextFigure, Drawing drawing) {
        StringMatch stringMatch = this._parser.findUplink(cPNTextFigure.getText(), this._channel, this._parameterCount);
        if (stringMatch != null) {
            StringMatch stringMatch2 = this._parser.findChannelName(stringMatch.match());
            return new UplinkMatch(drawing, cPNTextFigure, stringMatch, stringMatch2, this._parameterCount);
        }
        return null;
    }

    private List<DownlinkMatch> findDownlinks(CPNTextFigure cPNTextFigure, Drawing drawing) {
        ArrayList<DownlinkMatch> arrayList = new ArrayList<DownlinkMatch>();
        List<StringMatch> list = this._parser.findDownlinks(cPNTextFigure.getText(), this._channel, this._parameterCount);
        for (StringMatch stringMatch : list) {
            StringMatch stringMatch2 = this._parser.findChannelName(stringMatch.match());
            DownlinkMatch downlinkMatch = new DownlinkMatch(drawing, cPNTextFigure, stringMatch, stringMatch2, this._parameterCount);
            arrayList.add(downlinkMatch);
        }
        return arrayList;
    }
}

