/*
 * Decompiled with CFR 0.152.
 */
package de.renew.refactoring.edit;

import de.renew.refactoring.edit.IteratorEditor;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class LineByLineFileEditor
extends IteratorEditor<File, Void> {
    private static Logger logger = Logger.getLogger(LineByLineFileEditor.class);

    public LineByLineFileEditor(List<File> list) {
        super(list);
    }

    @Override
    public String getCurrentEditString() {
        return ((File)this.getCurrentEdit()).getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Void performEdit(File file) {
        BufferedReader bufferedReader = null;
        BufferedWriter bufferedWriter = null;
        try {
            File file2 = new File(file.getPath() + "tmp");
            file2.createNewFile();
            bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            bufferedWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file2)));
            String string = bufferedReader.readLine();
            while (string != null) {
                String string2 = this.editLine(string);
                bufferedWriter.write(string2);
                bufferedWriter.newLine();
                string = bufferedReader.readLine();
            }
            if (file.delete() && file2.renameTo(file)) {
                logger.info((Object)("Replacing file successful: " + String.valueOf(file)));
            }
        }
        catch (IOException iOException) {
            logger.error((Object)("I/O Error occured while trying to replace " + String.valueOf(file) + "."));
            iOException.printStackTrace();
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            try {
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return null;
    }

    protected abstract String editLine(String var1);
}

