/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.RoundRectangleFigure;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.standard.AbstractHandle;
import CH.ifa.draw.util.Geom;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import org.freehep.graphicsio.VectorGraphicsIO;

class RadiusHandle
extends AbstractHandle {
    private static final int OFFSET = 3;
    private Point fRadius;
    private RoundRectangleFigure fOwner;

    public RadiusHandle(RoundRectangleFigure roundRectangleFigure) {
        super(roundRectangleFigure);
        this.fOwner = roundRectangleFigure;
    }

    @Override
    public void invokeStart(int n, int n2, DrawingView drawingView) {
        super.invokeStart(n, n2, drawingView);
        this.fRadius = this.fOwner.getArc();
        this.fRadius.x /= 2;
        this.fRadius.y /= 2;
    }

    @Override
    public void invokeStep(int n, int n2, int n3, int n4, DrawingView drawingView) {
        int n5 = n - n3;
        int n6 = n2 - n4;
        Rectangle rectangle = this.fOwner.displayBox();
        int n7 = Geom.range(0, rectangle.width, 2 * (this.fRadius.x + n5));
        int n8 = Geom.range(0, rectangle.height, 2 * (this.fRadius.y + n6));
        this.fOwner.setArc(n7, n8);
    }

    @Override
    public Point locate() {
        Point point = this.fOwner.getArc();
        Rectangle rectangle = this.fOwner.displayBox();
        return new Point(rectangle.x + point.x / 2 + 3, rectangle.y + point.y / 2 + 3);
    }

    @Override
    public void draw(Graphics graphics) {
        Rectangle rectangle = this.displayBox();
        graphics.setColor(Color.yellow);
        if (graphics instanceof VectorGraphicsIO) {
            graphics.fillOval(rectangle.x + 1, rectangle.y + 1, rectangle.width - 1, rectangle.height - 1);
        } else {
            graphics.fillOval(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        graphics.setColor(Color.black);
        graphics.drawOval(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }
}

