/*
 * Decompiled with CFR 0.152.
 */
package de.renew.net;

import java.io.Serializable;

public class NetElementID
implements Serializable {
    public static final Serializable DEFAULT_GROUP_ID = new DefaultGroupID();
    private int figureID;
    private Serializable groupID;

    public NetElementID() {
        this.groupID = DEFAULT_GROUP_ID;
    }

    public NetElementID(int n) {
        this.figureID = n;
        this.groupID = DEFAULT_GROUP_ID;
    }

    public NetElementID(int n, Serializable serializable) {
        if (serializable == null) {
            throw new IllegalArgumentException("A null group id is invalid");
        }
        this.figureID = n;
        this.groupID = serializable;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof NetElementID) {
            NetElementID netElementID = (NetElementID)object;
            return netElementID.getFigureID() == this.figureID && this.groupID.equals(netElementID.getGroupID());
        }
        return false;
    }

    public int getFigureID() {
        return this.figureID;
    }

    public Serializable getGroupID() {
        return this.groupID;
    }

    public int hashCode() {
        if (this.groupID != null) {
            return this.figureID + this.groupID.hashCode();
        }
        return this.figureID;
    }

    public String toString() {
        return "[" + this.figureID + "," + String.valueOf(this.groupID) + "]";
    }

    public static class DefaultGroupID
    implements Serializable {
        private DefaultGroupID() {
        }

        public boolean equals(Object object) {
            return object instanceof DefaultGroupID;
        }

        public int hashCode() {
            return 1234;
        }

        public String toString() {
            return "_default";
        }
    }
}

