/*
 * Decompiled with CFR 0.152.
 */
package de.renew.expression;

import de.renew.expression.Expression;
import de.renew.expression.Function;
import de.renew.expression.VariableMapper;
import de.renew.unify.CalculationChecker;
import de.renew.unify.Impossible;
import de.renew.unify.Notifiable;
import de.renew.unify.StateRecorder;
import de.renew.unify.Unify;
import de.renew.unify.Variable;
import de.renew.util.Types;
import de.renew.util.Value;

public class GuardExpression
implements Expression {
    Expression argument;
    Function function;

    public GuardExpression(Expression expression, Function function) {
        this.argument = expression;
        this.function = function;
    }

    @Override
    public boolean isInvertible() {
        return this.argument.isInvertible();
    }

    @Override
    public Class<?> getType() {
        return this.argument.getType();
    }

    public Expression getArgument() {
        return this.argument;
    }

    @Override
    public Object startEvaluation(VariableMapper variableMapper, StateRecorder stateRecorder, CalculationChecker calculationChecker) throws Impossible {
        final Variable variable = new Variable(this.argument.startEvaluation(variableMapper, stateRecorder, calculationChecker), stateRecorder);
        if (calculationChecker != null) {
            calculationChecker.addEarlyVariable(variable, stateRecorder);
        }
        Notifiable notifiable = new Notifiable(){

            @Override
            public void boundNotify(StateRecorder stateRecorder) throws Impossible {
                if (Unify.isBound(variable)) {
                    Object object = GuardExpression.this.function.function(variable.getValue());
                    if (object instanceof Value) {
                        object = ((Value)object).value;
                    }
                    if (!Boolean.TRUE.equals(object)) {
                        throw new Impossible();
                    }
                }
            }
        };
        variable.addListener(notifiable, stateRecorder);
        return variable.getValue();
    }

    @Override
    public Object registerCalculation(VariableMapper variableMapper, StateRecorder stateRecorder, CalculationChecker calculationChecker) throws Impossible {
        return this.argument.registerCalculation(variableMapper, stateRecorder, calculationChecker);
    }

    public String toString() {
        return "GuardExpr(" + Types.typeToString(this.getType()) + ": " + String.valueOf(this.function) + ", " + String.valueOf(this.argument) + ")";
    }
}

