/*
 * Decompiled with CFR 0.152.
 */
package de.renew.expression;

import de.renew.expression.Expression;
import de.renew.expression.VariableMapper;
import de.renew.unify.CalculationChecker;
import de.renew.unify.Impossible;
import de.renew.unify.StateRecorder;
import de.renew.unify.Variable;
import de.renew.util.Types;

public abstract class AggregateExpression
implements Expression {
    static final long serialVersionUID = -4094960769944117557L;
    private Expression[] expressions;
    private boolean invertible = true;

    public AggregateExpression(Expression[] expressionArray) {
        this.expressions = expressionArray;
        this.invertible = false;
        for (int i = 0; i < expressionArray.length; ++i) {
            this.invertible = this.invertible || expressionArray[i].isInvertible();
        }
    }

    @Override
    public boolean isInvertible() {
        return this.invertible;
    }

    public Expression[] getExpressions() {
        return this.expressions;
    }

    @Override
    public abstract Class<?> getType();

    protected Object[] makeArray(VariableMapper variableMapper, StateRecorder stateRecorder, CalculationChecker calculationChecker, boolean bl) throws Impossible {
        int n = this.expressions.length;
        Variable[] variableArray = new Variable[n];
        for (int i = 0; i < n; ++i) {
            Expression expression = this.expressions[i];
            variableArray[i] = bl ? new Variable(expression.startEvaluation(variableMapper, stateRecorder, calculationChecker), stateRecorder) : new Variable(expression.registerCalculation(variableMapper, stateRecorder, calculationChecker), stateRecorder);
        }
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = variableArray[i].getValue();
        }
        return objectArray;
    }

    protected abstract Object makeResultAggregate(Object[] var1, StateRecorder var2) throws Impossible;

    @Override
    public Object startEvaluation(VariableMapper variableMapper, StateRecorder stateRecorder, CalculationChecker calculationChecker) throws Impossible {
        return this.makeResultAggregate(this.makeArray(variableMapper, stateRecorder, calculationChecker, true), stateRecorder);
    }

    @Override
    public Object registerCalculation(VariableMapper variableMapper, StateRecorder stateRecorder, CalculationChecker calculationChecker) throws Impossible {
        return this.makeResultAggregate(this.makeArray(variableMapper, stateRecorder, calculationChecker, false), stateRecorder);
    }

    public String toString() {
        String string = "AggregateExpr(" + Types.typeToString(this.getType()) + ": ";
        for (int i = 0; i < this.expressions.length; ++i) {
            if (i > 0) {
                string = string + ", ";
            }
            string = string + String.valueOf(this.expressions[i]);
        }
        string = string + ")";
        return string;
    }
}

