/*
 * Decompiled with CFR 0.152.
 */
package de.renew.lola.commands;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.standard.NullDrawing;
import CH.ifa.draw.util.Command;
import de.renew.gui.CPNDrawing;
import de.renew.gui.GuiPlugin;
import de.renew.lola.LolaFileCreator;
import de.renew.lola.LolaHelper;
import de.renew.plugin.command.CLCommand;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.log4j.Logger;

public class AnalyzeSpecifiedTasksCommand
extends Command
implements CLCommand {
    private static Logger logger = Logger.getLogger(AnalyzeSpecifiedTasksCommand.class);
    private File lolaPath;
    private File tmpDir;

    public AnalyzeSpecifiedTasksCommand(String string, String string2) {
        super(string);
        this.lolaPath = new File(string2);
        this.tmpDir = LolaHelper.findTmpDir();
    }

    public void execute(String[] stringArray, PrintStream printStream) {
    }

    public String getDescription() {
        return "Analyze file in lola format.";
    }

    public void execute() {
        Object object;
        File file;
        DrawingEditor drawingEditor = GuiPlugin.getCurrent().getDrawingEditor();
        Drawing drawing = drawingEditor.drawing();
        LolaFileCreator lolaFileCreator = new LolaFileCreator();
        File file2 = null;
        String string = "";
        File file3 = null;
        if (drawing instanceof NullDrawing) {
            file2 = this.chooseLolaFile();
            if (file2 == null) {
                logger.info((Object)"[Lola] Neither open drawing, nor file selected");
                return;
            }
            file3 = new File(file2.getParent());
            string = file2.getName().substring(0, file2.getName().indexOf(".net"));
            logger.info((Object)("[Lola] Choosen file: " + file2.toString()));
            logger.info((Object)("[Lola] Using task files in: " + file3.toString()));
        }
        final String string2 = drawing instanceof NullDrawing ? string : drawing.getName();
        File file4 = file = drawing instanceof NullDrawing ? file3 : new File(this.tmpDir, string2);
        if (drawing instanceof CPNDrawing) {
            if (file.exists()) {
                for (File file5 : file.listFiles()) {
                    file5.delete();
                }
                file.delete();
            }
            if (file.mkdir()) {
                logger.info((Object)("[Lola] Created temporary directory " + String.valueOf(file)));
                file2 = new File(file, string2 + ".net");
            } else {
                logger.info((Object)("[Lola] Could not create directory " + String.valueOf(file)));
                logger.info((Object)("[Lola] Instead using " + String.valueOf(this.tmpDir)));
                file2 = new File(file, string2 + ".net");
            }
            if (file2.exists()) {
                file2.delete();
            }
            try {
                file2.createNewFile();
                object = new FileOutputStream(file2);
                lolaFileCreator.writeLolaFile((OutputStream)object, (CPNDrawing)drawing);
                lolaFileCreator.createTasks((CPNDrawing)drawing, file2);
                ((OutputStream)object).flush();
                ((FileOutputStream)object).close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                logger.error((Object)("[Lola] tmpFile in " + this.tmpDir.toString() + "couldn't be created or written to"));
            }
        }
        logger.info((Object)("[Lola] Analyzing net " + file2.toString()));
        object = Runtime.getRuntime();
        File[] fileArray = file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().startsWith(string2) && file.toString().endsWith(".task");
            }
        });
        if (fileArray.length == 0) {
            logger.info((Object)("[Lola] No task files found for net " + string2));
        }
        for (File file6 : fileArray) {
            String string3 = this.filename2taskType(string2, file6.getName());
            String string4 = LolaHelper.taskCommandMap.get(string3);
            File file7 = new File(this.lolaPath, string4);
            String[] stringArray = new String[]{file7.toString(), file2.toString(), "-a", file6.toString()};
            logger.info((Object)("[Lola] Executing " + String.valueOf(stringArray)));
            try {
                String string5;
                Process process = ((Runtime)object).exec(stringArray);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                while ((string5 = bufferedReader.readLine()) != null) {
                    System.out.println(string5);
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                logger.error((Object)"[Lola] Execution failed");
                iOException.printStackTrace();
            }
        }
    }

    private String filename2taskType(String string, String string2) {
        String string3 = string2.substring(string.length(), string2.indexOf(".task"));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("[Lola] taskType before trimming: " + string3));
        }
        while (Character.isDigit(string3.charAt(string3.length() - 1))) {
            string3 = string3.substring(0, string3.length() - 1);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("[Lola] taskType trimmed: " + string3));
        }
        return string3;
    }

    private File chooseLolaFile() {
        JFrame jFrame = DrawPlugin.getGui().getFrame();
        JFileChooser jFileChooser = new JFileChooser(System.getProperty("user.dir"));
        FileNameExtensionFilter fileNameExtensionFilter = new FileNameExtensionFilter("lola net format", "net");
        jFileChooser.setFileFilter(fileNameExtensionFilter);
        jFileChooser.addChoosableFileFilter(fileNameExtensionFilter);
        jFileChooser.setDialogTitle("Select a file (in lola net format) to analyze.");
        int n = jFileChooser.showOpenDialog(jFrame);
        if (n != 0) {
            logger.info((Object)"User abort.");
            return null;
        }
        File file = jFileChooser.getSelectedFile();
        logger.info((Object)(file.toString() + " was selected"));
        return file;
    }
}

