/*
 * Decompiled with CFR 0.152.
 */
package de.renew.navigator.gui;

import de.renew.navigator.events.DirectoryOpeningEvent;
import de.renew.navigator.gui.FileTreeNode;
import de.renew.navigator.models.Directory;
import de.renew.navigator.models.NavigatorFileTree;
import de.renew.navigator.models.TreeElement;
import javax.swing.event.TreeExpansionEvent;

class TreeExpansionListener
implements javax.swing.event.TreeExpansionListener {
    private static boolean active = true;
    private final NavigatorFileTree model;

    public TreeExpansionListener(NavigatorFileTree navigatorFileTree) {
        this.model = navigatorFileTree;
    }

    public static boolean isActive() {
        return active;
    }

    public static void setActive(boolean bl) {
        active = bl;
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
        if (!active) {
            return;
        }
        FileTreeNode fileTreeNode = this.extractFileTreeNode(treeExpansionEvent);
        this.extractDirectory(fileTreeNode).setOpened(false);
        this.model.notifyObservers(new DirectoryOpeningEvent(false, fileTreeNode));
    }

    @Override
    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        if (!active) {
            return;
        }
        FileTreeNode fileTreeNode = this.extractFileTreeNode(treeExpansionEvent);
        this.extractDirectory(fileTreeNode).setOpened(true);
        this.model.notifyObservers(new DirectoryOpeningEvent(true, fileTreeNode));
    }

    private FileTreeNode extractFileTreeNode(TreeExpansionEvent treeExpansionEvent) {
        Object object = treeExpansionEvent.getPath().getLastPathComponent();
        if (!(object instanceof FileTreeNode)) {
            throw new IllegalArgumentException("Last path component has to be a FileTreeNode");
        }
        return (FileTreeNode)object;
    }

    private Directory extractDirectory(FileTreeNode fileTreeNode) {
        TreeElement treeElement = fileTreeNode.getModel();
        if (treeElement instanceof Directory) {
            return (Directory)treeElement;
        }
        return (Directory)treeElement.getParent();
    }
}

