/*
 * Decompiled with CFR 0.152.
 */
package de.renew.navigator.gui;

import de.renew.navigator.gui.FileTreeCellRenderer;
import de.renew.navigator.models.Directory;
import de.renew.navigator.models.Leaf;
import de.renew.navigator.models.TreeElement;
import java.awt.Font;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.tree.DefaultTreeCellRenderer;

class DefaultFileTreeCellRenderer
extends FileTreeCellRenderer {
    private final HashMap<String, Icon> icons = new HashMap();
    private Icon defaultIcon = null;

    public DefaultFileTreeCellRenderer() {
        this.setDefaultIcon("/de/renew/navigator/images/files/file.png");
        this.addIcon(".aip", "/de/renew/navigator/images/files/file-aip.png");
        this.addIcon(".draw", "/de/renew/navigator/images/files/file-draw.png");
        this.addIcon(".rnw", "/de/renew/navigator/images/files/file-net.png");
        this.addIcon(".net", "/de/renew/navigator/images/files/file-net.png");
        this.addIcon(".pnml", "/de/renew/navigator/images/files/file-net.png");
        this.addIcon(".arm", "/de/renew/navigator/images/files/file-arm.png");
        this.addIcon(".mad", "/de/renew/navigator/images/files/file-arm.png");
        this.addIcon(".java", "/de/renew/navigator/images/files/file-java.png");
        this.addIcon("build.xml", "/de/renew/navigator/images/files/file-ant.png");
        this.addIcon(".xml", "/de/renew/navigator/images/files/file-xml.png");
        this.addIcon(".xmi", "/de/renew/navigator/images/files/file-xml.png");
        this.addIcon(".md", "/de/renew/navigator/images/files/file-markdown.png");
        this.addIcon(".markdown", "/de/renew/navigator/images/files/file-markdown.png");
    }

    public void setDefaultIcon(String string) {
        this.defaultIcon = DefaultFileTreeCellRenderer.loadIcon(string);
    }

    public Icon addIcon(String string, String string2) {
        return this.icons.put(string, DefaultFileTreeCellRenderer.loadIcon(string2));
    }

    @Override
    public void render(DefaultTreeCellRenderer defaultTreeCellRenderer, TreeElement treeElement, boolean bl, boolean bl2) {
        if (this.defaultIcon != null) {
            defaultTreeCellRenderer.setIcon(this.defaultIcon);
        }
        defaultTreeCellRenderer.setToolTipText(treeElement.getFile().getAbsolutePath());
        if (treeElement instanceof Leaf) {
            this.renderLeaf(defaultTreeCellRenderer, (Leaf)treeElement);
        }
        if (treeElement instanceof Directory) {
            this.renderDirectory(defaultTreeCellRenderer, (Directory)treeElement, bl2);
        }
    }

    private void renderLeaf(DefaultTreeCellRenderer defaultTreeCellRenderer, Leaf leaf) {
        String string = leaf.getFile().getName();
        if (string.contains("_DC") || string.contains("DC_")) {
            DefaultFileTreeCellRenderer.applyIcon(defaultTreeCellRenderer, "/de/renew/navigator/images/files/file-dc.png");
            return;
        }
        if (string.contains("Ontology")) {
            DefaultFileTreeCellRenderer.applyIcon(defaultTreeCellRenderer, "/de/renew/navigator/images/files/file-ontology.png");
            return;
        }
        for (String string2 : this.icons.keySet()) {
            if (!string.endsWith(string2)) continue;
            Icon icon = this.icons.get(string2);
            defaultTreeCellRenderer.setIcon(icon);
            break;
        }
    }

    private void renderDirectory(DefaultTreeCellRenderer defaultTreeCellRenderer, Directory directory, boolean bl) {
        if (directory.getType() == null) {
            if (bl) {
                DefaultFileTreeCellRenderer.applyIcon(defaultTreeCellRenderer, "/de/renew/navigator/images/directories/pile-opened.png");
            } else {
                DefaultFileTreeCellRenderer.applyIcon(defaultTreeCellRenderer, "/de/renew/navigator/images/directories/pile-closed.png");
            }
            return;
        }
        switch (directory.getType()) {
            case PACKAGE: {
                DefaultFileTreeCellRenderer.applyIcon(defaultTreeCellRenderer, "/de/renew/navigator/images/directories/package.png");
                return;
            }
            case PLUGIN: {
                if (bl) {
                    DefaultFileTreeCellRenderer.applyIcon(defaultTreeCellRenderer, "/de/renew/navigator/images/directories/plugin-opened.png");
                } else {
                    DefaultFileTreeCellRenderer.applyIcon(defaultTreeCellRenderer, "/de/renew/navigator/images/directories/plugin-closed.png");
                }
                defaultTreeCellRenderer.setFont(new Font(defaultTreeCellRenderer.getFont().getName(), 1, defaultTreeCellRenderer.getFont().getSize()));
                return;
            }
            case SOURCE: {
                if (bl) {
                    DefaultFileTreeCellRenderer.applyIcon(defaultTreeCellRenderer, "/de/renew/navigator/images/directories/blue-opened.png");
                } else {
                    DefaultFileTreeCellRenderer.applyIcon(defaultTreeCellRenderer, "/de/renew/navigator/images/directories/blue-closed.png");
                }
                return;
            }
            case TEST_SOURCE: {
                if (bl) {
                    DefaultFileTreeCellRenderer.applyIcon(defaultTreeCellRenderer, "/de/renew/navigator/images/directories/green-opened.png");
                } else {
                    DefaultFileTreeCellRenderer.applyIcon(defaultTreeCellRenderer, "/de/renew/navigator/images/directories/green-closed.png");
                }
                return;
            }
        }
        if (bl) {
            DefaultFileTreeCellRenderer.applyIcon(defaultTreeCellRenderer, "/de/renew/navigator/images/directories/pile-opened.png");
        } else {
            DefaultFileTreeCellRenderer.applyIcon(defaultTreeCellRenderer, "/de/renew/navigator/images/directories/pile-closed.png");
        }
    }
}

