/*
 * Decompiled with CFR 0.152.
 */
package de.renew.util;

import de.renew.plugin.PluginManager;
import java.io.IOException;
import java.io.ObjectInput;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.log4j.Logger;

public class ClassSource {
    public static Logger logger = Logger.getLogger(ClassSource.class);
    private static ClassLoader loader = null;
    private static Object deserializer = null;
    private static Method deserializeMethod = null;

    private ClassSource() {
    }

    public static synchronized void setClassLoader(ClassLoader classLoader) {
        loader = classLoader;
        logger.debug((Object)("Configured ClassSource with class loader " + classLoader.toString()));
        try {
            deserializer = ClassSource.classForName("de.renew.util.ReloadableDeserializerImpl").newInstance();
            deserializeMethod = deserializer.getClass().getDeclaredMethod("readObject", ObjectInput.class);
            logger.debug((Object)("Derived deserializer with class loader " + String.valueOf(deserializer.getClass().getClassLoader())));
        }
        catch (Exception exception) {
            deserializer = null;
            logger.error((Object)("Cannot generate deserializer: " + String.valueOf(exception)), (Throwable)exception);
            throw new RuntimeException("Cannot generate deserializer.", exception);
        }
    }

    public static synchronized ClassLoader getClassLoader() {
        if (loader == null) {
            return ClassSource.getDefaultClassLoader();
        }
        return loader;
    }

    private static ClassLoader getDefaultClassLoader() {
        ClassLoader classLoader = PluginManager.getInstance().getBottomClassLoader();
        if (classLoader == null) {
            classLoader = ClassSource.class.getClassLoader();
        }
        return classLoader;
    }

    public static synchronized Class<?> classForName(String string) throws ClassNotFoundException {
        if (loader == null) {
            logger.debug((Object)("Looking up " + string + " in default class source."));
            return Class.forName(string, true, PluginManager.getInstance().getBottomClassLoader());
        }
        logger.debug((Object)("Looking up " + string + " in class source " + String.valueOf(loader) + "."));
        return Class.forName(string, true, loader);
    }

    public static Object readObject(ObjectInput objectInput) throws ClassNotFoundException, IOException {
        if (deserializer == null) {
            return objectInput.readObject();
        }
        try {
            return deserializeMethod.invoke(deserializer, objectInput);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)throwable;
            }
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new RuntimeException(throwable);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
    }
}

