/*
 * Decompiled with CFR 0.152.
 */
package de.renew.plugin.locate;

import de.renew.plugin.CollectionLister;
import de.renew.plugin.PluginProperties;
import de.renew.plugin.locate.PluginLocationFinder;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.Vector;
import org.apache.log4j.Logger;

public abstract class PluginFileFinder
implements PluginLocationFinder {
    public static Logger logger = Logger.getLogger(PluginFileFinder.class);
    private URL _pluginBase;

    public PluginFileFinder(URL uRL) {
        if (uRL == null) {
            try {
                uRL = new File(System.getProperty("user.dir")).toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                logger.error((Object)"PluginFileFinder: now, that IS strange.");
            }
        }
        this._pluginBase = uRL;
    }

    protected URL getPluginBase() {
        return this._pluginBase;
    }

    public String toString() {
        return "a PluginFileFinder looking below " + String.valueOf(this._pluginBase);
    }

    @Override
    public Collection<PluginProperties> findPluginLocations() {
        Collection<PluginProperties> collection = new Vector<PluginProperties>();
        try {
            URL uRL = this.getPluginBase();
            logger.debug((Object)(this.getClass().getName() + ": plugin base is " + uRL.toExternalForm()));
            File file = this.convert(uRL, true);
            if (file == null) {
                return new Vector<PluginProperties>();
            }
            if (!file.exists()) {
                logger.error((Object)("plugin directory " + String.valueOf(file) + " not found."));
                return new Vector<PluginProperties>();
            }
            if (!file.isDirectory()) {
                return new Vector<PluginProperties>();
            }
            File[] fileArray = this.getPluginFiles(file);
            collection = this.getPluginConfigurations(fileArray);
            logger.debug((Object)(collection.size() + " plugin locations found."));
            logger.debug((Object)CollectionLister.toString(collection));
        }
        catch (RuntimeException runtimeException) {
            logger.error((Object)"something went wrong looking for a plugin location.");
        }
        return collection;
    }

    @Override
    public PluginProperties checkPluginLocation(URL uRL) {
        Collection<PluginProperties> collection;
        URL uRL2;
        if (uRL == null || !"file".equals(uRL.getProtocol())) {
            return null;
        }
        try {
            uRL2 = new URL(this._pluginBase, uRL.getPath());
        }
        catch (MalformedURLException malformedURLException) {
            logger.error((Object)("PluginFileFinder: Strange URL \"" + String.valueOf(uRL) + "\": " + String.valueOf(malformedURLException)), (Throwable)malformedURLException);
            uRL2 = uRL;
        }
        File file = this.convert(uRL2, false);
        if (file != null && !(collection = this.getPluginConfigurations(new File[]{file})).isEmpty()) {
            return collection.iterator().next();
        }
        return null;
    }

    private File convert(URL uRL, boolean bl) {
        File file = null;
        try {
            file = new File(new URI(uRL.toExternalForm()));
        }
        catch (URISyntaxException uRISyntaxException) {
            if (bl) {
                logger.error((Object)("PluginFileFinder: Strange URL \"" + String.valueOf(uRL) + "\": " + String.valueOf(uRISyntaxException)), (Throwable)uRISyntaxException);
            }
            logger.debug((Object)("PluginFileFinder: Strange URL \"" + String.valueOf(uRL) + "\": " + String.valueOf(uRISyntaxException)), (Throwable)uRISyntaxException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (bl) {
                logger.error((Object)("PluginFileFinder: Not a file? URL \"" + String.valueOf(uRL) + "\": " + illegalArgumentException.getMessage()), (Throwable)illegalArgumentException);
            }
            logger.debug((Object)("PluginFileFinder: Not a file? URL \"" + String.valueOf(uRL) + "\": " + illegalArgumentException.getMessage()), (Throwable)illegalArgumentException);
        }
        catch (NullPointerException nullPointerException) {
            if (bl) {
                logger.error((Object)("PluginFileFinder: " + String.valueOf(nullPointerException)), (Throwable)nullPointerException);
            }
            logger.debug((Object)("PluginFileFinder: " + String.valueOf(nullPointerException)), (Throwable)nullPointerException);
        }
        return file;
    }

    protected abstract File[] getPluginFiles(File var1);

    protected abstract Collection<PluginProperties> getPluginConfigurations(File[] var1);
}

