/*
 * Decompiled with CFR 0.152.
 */
package de.renew.plugin;

import de.renew.plugin.CollectionLister;
import de.renew.plugin.PluginManager;
import de.renew.plugin.PropertyHelper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.apache.log4j.Logger;

public class PluginProperties
extends Properties {
    public static final String NAME = "name";
    public static final String MAIN_CLASS = "mainClass";
    public static final String REQUIRES = "requires";
    public static final String PROVIDES = "provides";
    public static final String UNKNOWN = "unknown";
    public static final String VERSION = "version";
    public static final String VERSION_TEXT = "versionText";
    public static final String VERSION_DATE = "versionDate";
    protected static PluginProperties _userProperties;
    private URL _sourceURL;
    public static Logger logger;
    public static final String NULL_VALUE = "<not set>";
    Collection<Object> _knownProperties = new HashSet<Object>();

    public PluginProperties(URL uRL, InputStream inputStream) throws IOException {
        this._sourceURL = uRL;
        this.load(inputStream);
        this.setKnownProperties();
        this._knownProperties.remove(NAME);
        this._knownProperties.remove(MAIN_CLASS);
        this._knownProperties.remove(REQUIRES);
        this._knownProperties.remove(PROVIDES);
        this._knownProperties.remove(VERSION);
        this._knownProperties.remove(VERSION_TEXT);
        this._knownProperties.remove(VERSION_DATE);
        this.removeNullProperties();
        this.putAll((Map<?, ?>)PluginProperties.getUserProperties());
        this.putAll((Map<?, ?>)System.getProperties());
    }

    public PluginProperties(URL uRL) {
        super(PluginProperties.getUserProperties());
        this.putAll((Map<?, ?>)System.getProperties());
        this._sourceURL = uRL;
    }

    protected PluginProperties() {
        this.putAll((Map<?, ?>)System.getProperties());
    }

    private void removeNullProperties() {
        Iterator<Map.Entry<Object, Object>> iterator = this.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            if (!NULL_VALUE.equals(entry.getValue())) continue;
            iterator.remove();
        }
    }

    public URL getURL() {
        return this._sourceURL;
    }

    public String getMainClass() {
        return this.getProperty(MAIN_CLASS, "");
    }

    public String getName() {
        return this.getProperty(NAME, UNKNOWN);
    }

    public String getVersion() {
        return this.getProperty(VERSION, UNKNOWN);
    }

    public String getVersionDate() {
        return this.getProperty(VERSION_DATE, UNKNOWN);
    }

    public String getVersionText() {
        return this.getProperty(VERSION_TEXT, UNKNOWN);
    }

    public Collection<String> getProvisions() {
        String string = this.getProperty(PROVIDES, "");
        return PropertyHelper.parseListString(string);
    }

    public Collection<String> getRequirements() {
        String string = this.getProperty(REQUIRES, "");
        return PropertyHelper.parseListString(string);
    }

    public String[] getKnownProperties() {
        return this._knownProperties.toArray(new String[this._knownProperties.size()]);
    }

    public boolean isKnownProperty(String string) {
        return this._knownProperties.contains(string);
    }

    @Override
    public synchronized String toString() {
        return "properties of Plugin " + this.getName();
    }

    public String toExtString() {
        String string = "properties of Plugin " + this.getName() + ":\n";
        string = string + "loaded from URL " + String.valueOf(this.getURL()) + "\n";
        string = string + "main class is " + this.getMainClass() + "\n";
        string = string + "provides " + CollectionLister.toString(this.getProvisions()) + "\n";
        string = string + "requires " + CollectionLister.toString(this.getRequirements());
        return string;
    }

    public static PluginProperties getUserProperties() {
        if (_userProperties == null) {
            String string;
            String string2;
            PluginProperties pluginProperties = new PluginProperties();
            URL uRL = null;
            try {
                uRL = PluginManager.getLoaderLocation();
                string2 = uRL.toExternalForm();
                string2 = string2.substring(0, string2.lastIndexOf("/"));
                uRL = new URL(string2 + "/config/renew.properties");
            }
            catch (Exception exception) {
                string = exception.toString();
                logger.warn((Object)("Could not determine installation properties file name: " + string));
                logger.debug((Object)string, (Throwable)exception);
                uRL = null;
            }
            PluginProperties.fillProperties(uRL, "installation", pluginProperties);
            try {
                string2 = System.getProperty("user.home");
                uRL = new File(string2 + File.separator + ".renew.properties").toURI().toURL();
            }
            catch (Exception exception) {
                string = exception.toString();
                logger.warn((Object)("Could not determine user properties file name: " + string));
                logger.debug((Object)string, (Throwable)exception);
                uRL = null;
            }
            PluginProperties.fillProperties(uRL, "user", pluginProperties);
            pluginProperties.putAll((Map<?, ?>)System.getProperties());
            _userProperties = pluginProperties;
        }
        return _userProperties;
    }

    private static boolean fillProperties(URL uRL, String string, PluginProperties pluginProperties) {
        if (uRL == null) {
            return false;
        }
        try {
            InputStream inputStream = uRL.openStream();
            logger.info((Object)("Reading " + string + " properties from " + uRL.toExternalForm()));
            pluginProperties.load(inputStream);
            pluginProperties._sourceURL = uRL;
            return true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            logger.info((Object)("No " + string + " properties: " + fileNotFoundException.getMessage()));
        }
        catch (IOException iOException) {
            String string2 = iOException.toString();
            logger.warn((Object)("Could not read " + string + " properties " + uRL.toExternalForm() + ": " + string2));
            logger.debug((Object)string2, (Throwable)iOException);
        }
        return false;
    }

    public boolean getBoolProperty(String string) {
        return PropertyHelper.getBoolProperty(this, string);
    }

    public boolean getBoolProperty(String string, boolean bl) {
        return PropertyHelper.getBoolProperty(this, string, bl);
    }

    public int getIntProperty(String string, int n) {
        return PropertyHelper.getIntProperty(this, string, n);
    }

    public int getIntProperty(String string) {
        return PropertyHelper.getIntProperty(this, string);
    }

    public List<String> getListProperty(String string) {
        return PropertyHelper.getListProperty(this, string);
    }

    public String getFilteredProperty(String string) {
        String string2;
        Enumeration<Object> enumeration = this.keys();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            if (!string2.equals(string)) continue;
            return (String)this.get(string2);
        }
        enumeration = this.keys();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            logger.debug((Object)("PluginProperties@getFilteredProperty key: " + string2 + " filter: " + string + " " + string2.endsWith(string)));
            if (!string2.endsWith(string)) continue;
            return (String)this.get(string2);
        }
        return "";
    }

    public Collection<String> getUnsetProperties() {
        String[] stringArray = this.getKnownProperties();
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            logger.debug((Object)("PluginProperies@getUnsetProperties: checking for null: " + stringArray[i]));
            if (this.get(stringArray[i]) != null) continue;
            hashSet.add(stringArray[i]);
        }
        return hashSet;
    }

    public void setKnownProperties() {
        this._knownProperties.addAll(this.keySet());
    }

    public Collection<String> getKeys() {
        Enumeration<Object> enumeration = this.keys();
        Vector<String> vector = new Vector<String>();
        while (enumeration.hasMoreElements()) {
            vector.add((String)enumeration.nextElement());
        }
        return vector;
    }

    static {
        logger = Logger.getLogger(PluginProperties.class);
    }
}

