/*
 * Decompiled with CFR 0.152.
 */
package de.renew.remote;

import de.renew.application.SimulationEnvironment;
import de.renew.engine.common.StepIdentifier;
import de.renew.engine.simulator.Binding;
import de.renew.engine.simulator.SimulationThreadPool;
import de.renew.remote.BindingAccessor;
import de.renew.remote.SocketFactoryDeterminer;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

public class BindingAccessorImpl
extends UnicastRemoteObject
implements BindingAccessor {
    public static Logger logger = Logger.getLogger(BindingAccessorImpl.class);
    private SimulationEnvironment environment;
    protected final Binding binding;

    public BindingAccessorImpl(Binding binding, SimulationEnvironment simulationEnvironment) throws RemoteException {
        super(0, SocketFactoryDeterminer.getInstance(), SocketFactoryDeterminer.getInstance());
        this.binding = binding;
        this.environment = simulationEnvironment;
    }

    @Override
    public boolean execute(final boolean bl) throws RemoteException {
        final StepIdentifier stepIdentifier = this.environment.getSimulator().nextStepIdentifier();
        Future future = SimulationThreadPool.getCurrent().submitAndWait((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return BindingAccessorImpl.this.binding.execute(stepIdentifier, bl);
            }
        });
        try {
            return (Boolean)future.get();
        }
        catch (InterruptedException interruptedException) {
            logger.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)interruptedException);
        }
        catch (ExecutionException executionException) {
            logger.error((Object)"Simulation thread threw an exception", (Throwable)executionException);
        }
        return false;
    }

    @Override
    public String getDescription() throws RemoteException {
        Future future = SimulationThreadPool.getCurrent().submitAndWait((Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                return BindingAccessorImpl.this.binding.getDescription();
            }
        });
        try {
            return (String)future.get();
        }
        catch (InterruptedException interruptedException) {
            logger.error((Object)"Timeout while waiting for simulation thread to finish", (Throwable)interruptedException);
        }
        catch (ExecutionException executionException) {
            logger.error((Object)"Simulation thread threw an exception", (Throwable)executionException);
        }
        return null;
    }
}

