/*
 * Decompiled with CFR 0.152.
 */
package de.renew.refactoring.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataListener;
import org.apache.log4j.Logger;

public abstract class ListPanel<T>
extends JPanel {
    private static final long serialVersionUID = 8757223583811214544L;
    private static Logger logger = Logger.getLogger(ListPanel.class);
    private final List<T> _data;
    private final JList<String> _list;

    public ListPanel(List<T> list) {
        this(list, null);
    }

    public ListPanel(List<T> list, String string) {
        this._data = list;
        this._list = new JList();
        this.createPanel(string != null ? string : "");
    }

    protected abstract String getTitleForItem(T var1);

    protected abstract void openItem(T var1);

    private void createPanel(String string) {
        Object object;
        this.setLayout(new BorderLayout(0, 10));
        if (!string.isEmpty()) {
            object = new JLabel(string);
            this.add((Component)object, "North");
        }
        this._list.setModel(new ListModel<String>(){

            @Override
            public int getSize() {
                return ListPanel.this._data.size();
            }

            @Override
            public String getElementAt(int n) {
                return ListPanel.this.getTitleForItem(ListPanel.this._data.get(n));
            }

            @Override
            public void addListDataListener(ListDataListener listDataListener) {
            }

            @Override
            public void removeListDataListener(ListDataListener listDataListener) {
            }
        });
        this.add(this._list, "Center");
        object = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    int n = ListPanel.this._list.locationToIndex(mouseEvent.getPoint());
                    logger.debug((Object)("Double clicked on Item " + n));
                    ListPanel.this.openItem(ListPanel.this._data.get(n));
                }
            }
        };
        this._list.addMouseListener((MouseListener)object);
    }

    public void focus() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ListPanel.this._list.requestFocusInWindow();
            }
        });
    }
}

