/*
 * Decompiled with CFR 0.152.
 */
package de.renew.refactoring.parse.name;

import de.renew.refactoring.match.StringMatch;
import de.renew.refactoring.parse.name.NameFinder;
import de.renew.refactoring.parse.name.NoNameFinder;
import de.renew.refactoring.parse.name.RegexNameFinder;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class RegexClassNameFinder
implements NameFinder {
    private static Logger logger = Logger.getLogger(RegexClassNameFinder.class);
    private final String _className;
    private final String _packageName;
    private final NameFinder _classNameFinder;
    private final NameFinder _qualifiedClassNameFinder;

    public RegexClassNameFinder(String string, boolean bl) {
        this(RegexClassNameFinder.className(string), RegexClassNameFinder.packageName(string), bl);
    }

    public RegexClassNameFinder(String string, String string2, boolean bl) {
        this._className = string;
        this._packageName = string2;
        this._classNameFinder = bl ? new RegexNameFinder(string, ".", null) : new NoNameFinder();
        this._qualifiedClassNameFinder = new RegexNameFinder(string2 + "." + string);
    }

    @Override
    public boolean find(String string) {
        return this._classNameFinder.find(string) || this._qualifiedClassNameFinder.find(string);
    }

    @Override
    public List<StringMatch> listOfMatches(String string) {
        ArrayList<StringMatch> arrayList = new ArrayList<StringMatch>(this._classNameFinder.listOfMatches(string));
        for (StringMatch stringMatch : this._qualifiedClassNameFinder.listOfMatches(string)) {
            int n = stringMatch.start() + stringMatch.match().lastIndexOf(this._className);
            int n2 = n + this._className.length();
            arrayList.add(new StringMatch(this._className, n, n2));
        }
        return arrayList;
    }

    private static String className(String string) {
        int n = string.lastIndexOf(46);
        return string.substring(n + 1);
    }

    private static String packageName(String string) {
        int n = string.lastIndexOf(46);
        return string.substring(0, n);
    }
}

