/*
 * Decompiled with CFR 0.152.
 */
package de.renew.refactoring.parse;

import de.renew.refactoring.match.StringMatch;
import de.renew.refactoring.parse.LinkParser;
import de.renew.refactoring.parse.Patterns;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexLinkParser
implements LinkParser {
    @Override
    public boolean isValidChannelName(String string) {
        return Patterns.NAME_PATTERN.matcher(string).matches();
    }

    @Override
    public boolean containsUplink(String string) {
        return Patterns.UPLINK_PATTERN.matcher(string).find();
    }

    @Override
    public boolean containsDownlink(String string) {
        return Patterns.DOWNLINK_PATTERN.matcher(string).find();
    }

    @Override
    public StringMatch findUplink(String string) {
        Matcher matcher = Patterns.UPLINK_PATTERN.matcher(string);
        if (matcher.find()) {
            return new StringMatch(string.substring(matcher.start(), matcher.end()), matcher.start(), matcher.end());
        }
        return null;
    }

    @Override
    public StringMatch findUplink(String string, String string2, int n) {
        return null;
    }

    @Override
    public StringMatch findChannelName(String string) {
        assert (this.containsUplink(string) || this.containsDownlink(string));
        int n = string.indexOf(58) + 1;
        int n2 = string.indexOf(40);
        return new StringMatch(string.substring(n, n2).trim(), n, n2);
    }

    @Override
    public int findParameterCount(String string) {
        int n;
        assert (this.containsUplink(string) || this.containsDownlink(string));
        int n2 = string.indexOf(40);
        String string2 = string.substring(n2 + 1, n = string.indexOf(41));
        if (string2.trim().isEmpty()) {
            return 0;
        }
        int n3 = 0;
        int n4 = 1;
        block5: for (int i = 0; i < string2.length(); ++i) {
            switch (string2.charAt(i)) {
                case '[': {
                    ++n3;
                    continue block5;
                }
                case ']': {
                    --n3;
                    continue block5;
                }
                case ',': {
                    if (n3 != 0) continue block5;
                    ++n4;
                    continue block5;
                }
            }
        }
        return n4;
    }

    @Override
    public boolean isDownlinkToThis(String string) {
        return Patterns.DOWNLINK_TO_THIS_PATTERN.matcher(string).matches();
    }

    @Override
    public List<StringMatch> findDownlinks(String string) {
        return null;
    }

    @Override
    public List<StringMatch> findDownlinks(String string, String string2, int n) {
        Pattern pattern = this.downlinkPatternForChannel(string2, n);
        ArrayList<StringMatch> arrayList = new ArrayList<StringMatch>();
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            int n2 = matcher.start();
            int n3 = matcher.end();
            String string3 = string.substring(n2, n3);
            StringMatch stringMatch = new StringMatch(string3, n2, n3);
            arrayList.add(stringMatch);
        }
        return arrayList;
    }

    protected Pattern downlinkPatternForChannel(String string, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Patterns.DOWNLINK_BEFORE_CHANNEL_NAME);
        stringBuilder.append(Patterns.addWhitespace(string));
        stringBuilder.append(Patterns.OPENING_PAR);
        if (n > 0) {
            stringBuilder.append(Patterns.PARAM);
        }
        if (n > 1) {
            stringBuilder.append("(," + Patterns.PARAM + ")");
            stringBuilder.append("{" + (n - 1) + "}");
        }
        stringBuilder.append(Patterns.CLOSING_PAR);
        return Pattern.compile(stringBuilder.toString());
    }
}

