/*
 * Decompiled with CFR 0.152.
 */
package de.renew.refactoring.parse;

import de.renew.formalism.java.JavaNetParser;
import de.renew.formalism.java.JavaNetParserTokenManager;
import de.renew.formalism.java.ParseException;
import de.renew.formalism.java.ParsedDeclarationNode;
import de.renew.formalism.java.Token;
import de.renew.net.TransitionInscription;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class JNPParser {
    private static Logger logger = Logger.getLogger(JNPParser.class);

    private JNPParser() {
    }

    public static JavaNetParser netParser(String string) {
        return JNPParser.netParser(string, new ParsedDeclarationNode());
    }

    public static JavaNetParser netParser(String string, ParsedDeclarationNode parsedDeclarationNode) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        JavaNetParser javaNetParser = new JavaNetParser((InputStream)byteArrayInputStream);
        javaNetParser.refactoring = true;
        javaNetParser.setDeclarationNode(parsedDeclarationNode);
        return javaNetParser;
    }

    public static JavaNetParserTokenManager tokenManager(JavaNetParser javaNetParser) {
        return javaNetParser.token_source;
    }

    public static boolean isIdentifier(JavaNetParser javaNetParser) {
        JavaNetParserTokenManager javaNetParserTokenManager = JNPParser.tokenManager(javaNetParser);
        Token token = javaNetParserTokenManager.getNextToken();
        boolean bl = javaNetParserTokenManager.getNextToken().kind == 0;
        return bl && token.kind == 70;
    }

    public static ParsedDeclarationNode declarationNode(String string) {
        try {
            return JNPParser.netParser(string).DeclarationNode();
        }
        catch (ParseException parseException) {
            logger.debug((Object)("Declaration node could not be parsed: " + string + ", " + parseException.getMessage()));
            return null;
        }
    }

    public static Collection<TransitionInscription> transitionInscriptions(JavaNetParser javaNetParser) {
        try {
            return javaNetParser.TransitionInscription(false, null);
        }
        catch (ParseException parseException) {
            logger.debug((Object)parseException.getMessage());
            return Collections.emptyList();
        }
    }

    public static TransitionInscription firstInscription(JavaNetParser javaNetParser) {
        Iterator<TransitionInscription> iterator = JNPParser.transitionInscriptions(javaNetParser).iterator();
        if (iterator.hasNext()) {
            TransitionInscription transitionInscription = iterator.next();
            return transitionInscription;
        }
        return null;
    }
}

