/*
 * Decompiled with CFR 0.152.
 */
package de.renew.refactoring.inline;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.standard.NullDrawingEditor;
import CH.ifa.draw.standard.TextHolder;
import de.renew.gui.CPNTextFigure;
import de.renew.refactoring.inline.FloatingRestrictedEditingTextField;
import de.renew.refactoring.inline.InlineStepWithListener;
import de.renew.refactoring.match.StringMatch;
import java.awt.Color;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.log4j.Logger;

public class RestrictedEditingTextFieldStep
extends InlineStepWithListener {
    private static Logger logger = Logger.getLogger(RestrictedEditingTextFieldStep.class);
    private CPNTextFigure _textFigure;
    private Container _container;
    private FloatingRestrictedEditingTextField _textField;
    private String _originalText;
    private String _lastKnownText;
    private String _lastKnownEditedText;
    private int _editCounter;

    public RestrictedEditingTextFieldStep(Container container, CPNTextFigure cPNTextFigure, StringMatch stringMatch) {
        this._container = container;
        this._textFigure = cPNTextFigure;
        this._originalText = cPNTextFigure.getText();
        this.beginEdit(stringMatch);
    }

    public void editedTextChanged(String string) {
    }

    public String getEditedText() {
        return this._textField.getEditedText();
    }

    public String getText() {
        return this._textField.getText();
    }

    protected KeyListener textFieldKeyListener() {
        return null;
    }

    protected MouseListener containerMouseListener() {
        return new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                RestrictedEditingTextFieldStep.this.endEdit();
            }
        };
    }

    public void setBorderColor(Color color) {
        this._textField.setBorderColor(color);
    }

    private void beginEdit(StringMatch stringMatch) {
        this._textField = new FloatingRestrictedEditingTextField(stringMatch.start(), stringMatch.end());
        this._textField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                RestrictedEditingTextFieldStep.this.edited();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                RestrictedEditingTextFieldStep.this.edited();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                RestrictedEditingTextFieldStep.this.edited();
            }
        });
        this._textField.addKeyListener(this.textFieldKeyListener());
        this._container.addMouseListener(this.containerMouseListener());
        this.setText(this._textFigure.getText());
        this._textField.select(stringMatch.start(), stringMatch.end());
        this._textField.createOverlay(this._container, RestrictedEditingTextFieldStep.fieldBounds((TextHolder)this._textFigure), this._textFigure.getFont());
    }

    private void edited() {
        String string;
        if (this.getText().isEmpty() && !this._lastKnownText.equals(this._lastKnownEditedText)) {
            return;
        }
        this._lastKnownText = this.getText();
        String string2 = string = this._lastKnownText.isEmpty() ? "" : this.getEditedText();
        if (string.equals(this._lastKnownEditedText)) {
            return;
        }
        this._lastKnownEditedText = string;
        this.editedTextChanged(string);
        this.updateTextFieldFromTextFigure();
        this._textFigure.setText(this._originalText);
        this._textFigure.changed();
    }

    private void updateTextFieldFromTextFigure() {
        final int n = ++this._editCounter;
        final String string = this._lastKnownText;
        final String string2 = this._textFigure.getText();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (n == RestrictedEditingTextFieldStep.this._editCounter && !string2.equals(string)) {
                    int n2 = RestrictedEditingTextFieldStep.this._textField.getCaretPosition();
                    RestrictedEditingTextFieldStep.this.setText(string2);
                    RestrictedEditingTextFieldStep.this._textField.setCaretPosition(n2);
                }
            }
        });
    }

    private void setText(String string) {
        this._textField.setText(string);
        this._lastKnownText = string;
    }

    public void endEdit() {
        String string = this.getText();
        this._textFigure.setText(string);
        if (string.trim().length() == 0) {
            RestrictedEditingTextFieldStep.getEditor().drawing().remove((Figure)this._textFigure);
        }
        this._textField.endOverlay();
        RestrictedEditingTextFieldStep.getEditor().view().checkDamage();
        RestrictedEditingTextFieldStep.getEditor().toolDone();
        this.informListenersFinished();
    }

    private static Rectangle fieldBounds(TextHolder textHolder) {
        Rectangle rectangle = textHolder.textDisplayBox();
        return rectangle;
    }

    private static DrawingEditor getEditor() {
        DrawPlugin drawPlugin = DrawPlugin.getCurrent();
        return drawPlugin == null ? NullDrawingEditor.INSTANCE : drawPlugin.getDrawingEditor();
    }
}

