/*
 * Decompiled with CFR 0.152.
 */
package de.renew.refactoring.edit;

import de.renew.refactoring.match.Match;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class MatchSorter<T extends Match, S> {
    private static Logger logger = Logger.getLogger(MatchSorter.class);
    private Comparator<T> _comparator;

    public List<T> sorted(List<T> list) {
        Map<S, List<T>> map = this.groupedMatches(list);
        for (List<T> object : map.values()) {
            this.sortGroup(object);
        }
        ArrayList arrayList = new ArrayList();
        for (List<T> list2 : map.values()) {
            arrayList.addAll(list2);
        }
        return arrayList;
    }

    protected abstract S group(T var1);

    private Map<S, List<T>> groupedMatches(List<T> list) {
        HashMap hashMap = new HashMap();
        for (Match match : list) {
            S s = this.group(match);
            if (!hashMap.containsKey(s)) {
                hashMap.put(s, new ArrayList());
            }
            ((List)hashMap.get(s)).add(match);
        }
        return hashMap;
    }

    private void sortGroup(List<T> list) {
        if (this._comparator == null) {
            this._comparator = new Comparator<T>(){

                @Override
                public int compare(T t, T t2) {
                    return ((Match)t2).getStart() - ((Match)t).getStart();
                }
            };
        }
        Collections.sort(list, this._comparator);
    }
}

