/*
 * Decompiled with CFR 0.152.
 */
package de.renew.formalism.pt;

import de.renew.expression.ConstantExpression;
import de.renew.expression.Expression;
import de.renew.formalism.base.AbstractSingleNetCompiler;
import de.renew.net.ConstantTokenSource;
import de.renew.net.Place;
import de.renew.net.TokenSource;
import de.renew.net.Transition;
import de.renew.net.TransitionInscription;
import de.renew.net.arc.Arc;
import de.renew.shadow.ShadowArc;
import de.renew.shadow.ShadowDeclarationNode;
import de.renew.shadow.ShadowInscribable;
import de.renew.shadow.ShadowInscription;
import de.renew.shadow.ShadowNet;
import de.renew.shadow.ShadowPlace;
import de.renew.shadow.SyntaxException;
import de.renew.unify.Tuple;
import java.util.Collection;
import java.util.Iterator;

public class SinglePTNetCompiler
extends AbstractSingleNetCompiler {
    public String checkDeclarationNode(String string, boolean bl, ShadowNet shadowNet) throws SyntaxException {
        throw new SyntaxException("Declaration node is not allowed.");
    }

    public String checkArcInscription(String string, boolean bl, ShadowNet shadowNet) throws SyntaxException {
        SinglePTNetCompiler.parseNumber(string);
        return "inscription";
    }

    public String checkTransitionInscription(String string, boolean bl, ShadowNet shadowNet) throws SyntaxException {
        throw new SyntaxException("Transition inscription is not allowed.");
    }

    public String checkPlaceInscription(String string, boolean bl, ShadowNet shadowNet) throws SyntaxException {
        SinglePTNetCompiler.parseNumber(string);
        return "initialMarking";
    }

    private static int parseNumber(String string) throws SyntaxException {
        try {
            return Integer.parseInt(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw new SyntaxException("Number expected", (Throwable)numberFormatException).addObject((Object)string);
        }
    }

    protected static int parseNumericalInscription(ShadowInscribable shadowInscribable, int n, int n2) throws SyntaxException {
        int n3 = n;
        boolean bl = false;
        for (Object e : shadowInscribable.elements()) {
            if (e instanceof ShadowInscription) {
                if (bl) {
                    throw new SyntaxException("Multiple inscriptions not supported").addObject((Object)shadowInscribable);
                }
                bl = true;
                n3 = SinglePTNetCompiler.parseNumber(((ShadowInscription)e).inscr);
                continue;
            }
            if (e instanceof ShadowArc) continue;
            throw new SyntaxException("Unsupported inscription").addObject((Object)shadowInscribable).addObject(e);
        }
        if (n3 < n2) {
            throw new SyntaxException("Inscribed value must not be lower than " + n2).addObject((Object)shadowInscribable);
        }
        return n3;
    }

    @Override
    protected void compilePlaceInscriptions(ShadowPlace shadowPlace, Place place) throws SyntaxException {
        int n = SinglePTNetCompiler.parseNumericalInscription((ShadowInscribable)shadowPlace, 0, 0);
        for (int i = 0; i < n; ++i) {
            place.add((TokenSource)new ConstantTokenSource((Object)Tuple.NULL));
        }
    }

    @Override
    protected void compileArc(ShadowArc shadowArc) throws SyntaxException {
        int n = shadowArc.shadowArcType;
        if (n != 1) {
            throw new SyntaxException("Unsupported arc type").addObject((Object)shadowArc);
        }
        int n2 = shadowArc.placeToTransition ? -1 : 1;
        int n3 = SinglePTNetCompiler.parseNumericalInscription((ShadowInscribable)shadowArc, 1, 1);
        Transition transition = this.lookup.get(shadowArc.transition);
        Place place = this.lookup.get(shadowArc.place);
        for (int i = 0; i < n3; ++i) {
            Arc arc = new Arc(place, transition, n2, (Expression)new ConstantExpression(null, (Object)Tuple.NULL), ConstantExpression.doubleZeroExpression);
            transition.add((TransitionInscription)arc);
        }
    }

    @Override
    protected Collection<TransitionInscription> compileTransitionInscription(ShadowInscription shadowInscription) throws SyntaxException {
        throw new SyntaxException("Transitions may not carry inscriptions").addObject((Object)shadowInscription);
    }

    @Override
    public void parseDeclarations(ShadowNet shadowNet) throws SyntaxException {
        Iterator iterator = shadowNet.elements().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof ShadowDeclarationNode)) continue;
            SyntaxException syntaxException = new SyntaxException("Declaration node is not allowed.");
            syntaxException.addObject(e);
            while (iterator.hasNext()) {
                e = iterator.next();
                if (!(e instanceof ShadowDeclarationNode)) continue;
                syntaxException.addObject(e);
            }
            throw syntaxException;
        }
    }
}

