/*
 * Decompiled with CFR 0.152.
 */
package de.renew.formalism.function;

import de.renew.expression.Function;
import de.renew.unify.Impossible;
import de.renew.unify.Tuple;
import de.renew.util.Value;
import java.lang.constant.Constable;
import java.lang.reflect.InvocationTargetException;

public class BasicFunction
implements Function {
    private static final int iLOR = 1;
    private static final int iLAND = 2;
    private static final int iOR = 3;
    private static final int iAND = 4;
    private static final int iXOR = 5;
    private static final int iEQUAL = 6;
    private static final int iNEQUAL = 7;
    private static final int iLESS = 8;
    private static final int iGREATER = 9;
    private static final int iLESSEQUAL = 10;
    private static final int iGREATEREQUAL = 11;
    private static final int iSHL = 12;
    private static final int iSHR = 13;
    private static final int iSSHR = 14;
    private static final int iPLUS = 15;
    private static final int iMINUS = 16;
    private static final int iTIMES = 17;
    private static final int iDIVIDE = 18;
    private static final int iMOD = 19;
    public static final BasicFunction LOR = new BasicFunction(1);
    public static final BasicFunction LAND = new BasicFunction(2);
    public static final BasicFunction OR = new BasicFunction(3);
    public static final BasicFunction AND = new BasicFunction(4);
    public static final BasicFunction XOR = new BasicFunction(5);
    public static final BasicFunction EQUAL = new BasicFunction(6);
    public static final BasicFunction NEQUAL = new BasicFunction(7);
    public static final BasicFunction LESS = new BasicFunction(8);
    public static final BasicFunction GREATER = new BasicFunction(9);
    public static final BasicFunction LESSEQUAL = new BasicFunction(10);
    public static final BasicFunction GREATEREQUAL = new BasicFunction(11);
    public static final BasicFunction SHL = new BasicFunction(12);
    public static final BasicFunction SHR = new BasicFunction(13);
    public static final BasicFunction SSHR = new BasicFunction(14);
    public static final BasicFunction PLUS = new BasicFunction(15);
    public static final BasicFunction MINUS = new BasicFunction(16);
    public static final BasicFunction TIMES = new BasicFunction(17);
    public static final BasicFunction DIVIDE = new BasicFunction(18);
    public static final BasicFunction MOD = new BasicFunction(19);
    private static final String[] funcNames = new String[20];
    private int funcNum;

    private BasicFunction(int n) {
        this.funcNum = n;
    }

    private String generalToString(Object object) {
        if (object == null) {
            return "null";
        }
        if (object instanceof Value) {
            return ((Value)object).value.toString();
        }
        return object.toString();
    }

    public Object function(Object object) throws Impossible {
        Constable constable;
        Tuple tuple = (Tuple)object;
        if (tuple.getArity() != 2) {
            throw new Impossible();
        }
        Object object2 = tuple.getComponent(0);
        Object object3 = tuple.getComponent(1);
        if ((object2 instanceof String || object3 instanceof String) && this.funcNum == 15) {
            return this.generalToString(object2) + this.generalToString(object3);
        }
        if (object2 instanceof Value ^ object3 instanceof Value) {
            throw new Impossible();
        }
        if (!(object2 instanceof Value)) {
            return new Value((Object)(switch (this.funcNum) {
                case 6 -> new Boolean(object2 == object3);
                case 7 -> new Boolean(object2 != object3);
                default -> throw new Impossible();
            }));
        }
        object2 = ((Value)object2).value;
        object3 = ((Value)object3).value;
        if (object2 instanceof Boolean) {
            if (object3 instanceof Boolean) {
                boolean bl = (Boolean)object2;
                boolean bl2 = (Boolean)object3;
                return new Value((Object)(switch (this.funcNum) {
                    case 1 -> new Boolean(bl || bl2);
                    case 2 -> new Boolean(bl && bl2);
                    case 3 -> new Boolean(bl | bl2);
                    case 4 -> new Boolean(bl & bl2);
                    case 5 -> new Boolean(bl ^ bl2);
                    case 6 -> new Boolean(bl == bl2);
                    case 7 -> new Boolean(bl != bl2);
                    default -> throw new Impossible();
                }));
            }
            throw new Impossible();
        }
        if (object2 instanceof Character) {
            object2 = new Integer(((Character)object2).charValue());
        }
        if (object3 instanceof Character) {
            object3 = new Integer(((Character)object3).charValue());
        }
        if (object2 instanceof Double || object3 instanceof Double) {
            Constable constable2;
            double d = ((Number)object2).doubleValue();
            double d2 = ((Number)object3).doubleValue();
            try {
                switch (this.funcNum) {
                    case 6: {
                        constable2 = new Boolean(d == d2);
                        break;
                    }
                    case 7: {
                        constable2 = new Boolean(d != d2);
                        break;
                    }
                    case 8: {
                        constable2 = new Boolean(d < d2);
                        break;
                    }
                    case 9: {
                        constable2 = new Boolean(d > d2);
                        break;
                    }
                    case 10: {
                        constable2 = new Boolean(d <= d2);
                        break;
                    }
                    case 11: {
                        constable2 = new Boolean(d >= d2);
                        break;
                    }
                    case 15: {
                        constable2 = new Double(d + d2);
                        break;
                    }
                    case 16: {
                        constable2 = new Double(d - d2);
                        break;
                    }
                    case 17: {
                        constable2 = new Double(d * d2);
                        break;
                    }
                    case 18: {
                        constable2 = new Double(d / d2);
                        break;
                    }
                    case 19: {
                        constable2 = new Double(d % d2);
                        break;
                    }
                    default: {
                        throw new Impossible();
                    }
                }
            }
            catch (Exception exception) {
                if (exception instanceof InvocationTargetException) {
                    throw new Impossible("InvocationTargetException occured during method call: " + String.valueOf(((InvocationTargetException)exception).getTargetException()));
                }
                throw new Impossible("Exception occured during method call: " + String.valueOf(exception));
            }
            return new Value((Object)constable2);
        }
        if (object2 instanceof Float || object3 instanceof Float) {
            Constable constable3;
            float f = ((Number)object2).floatValue();
            float f2 = ((Number)object3).floatValue();
            try {
                switch (this.funcNum) {
                    case 6: {
                        constable3 = new Boolean(f == f2);
                        break;
                    }
                    case 7: {
                        constable3 = new Boolean(f != f2);
                        break;
                    }
                    case 8: {
                        constable3 = new Boolean(f < f2);
                        break;
                    }
                    case 9: {
                        constable3 = new Boolean(f > f2);
                        break;
                    }
                    case 10: {
                        constable3 = new Boolean(f <= f2);
                        break;
                    }
                    case 11: {
                        constable3 = new Boolean(f >= f2);
                        break;
                    }
                    case 15: {
                        constable3 = new Float(f + f2);
                        break;
                    }
                    case 16: {
                        constable3 = new Float(f - f2);
                        break;
                    }
                    case 17: {
                        constable3 = new Float(f * f2);
                        break;
                    }
                    case 18: {
                        constable3 = new Float(f / f2);
                        break;
                    }
                    case 19: {
                        constable3 = new Float(f % f2);
                        break;
                    }
                    default: {
                        throw new Impossible();
                    }
                }
            }
            catch (Exception exception) {
                throw new Impossible();
            }
            return new Value((Object)constable3);
        }
        if (this.funcNum == 12 || this.funcNum == 13 || this.funcNum == 14) {
            if (object2 instanceof Long) {
                long l = ((Number)object2).longValue();
                long l2 = ((Number)object3).longValue();
                return new Value((Object)(switch (this.funcNum) {
                    case 12 -> new Long(l << (int)l2);
                    case 13 -> new Long(l >> (int)l2);
                    case 14 -> new Long(l >>> (int)l2);
                    default -> throw new Impossible();
                }));
            }
            int n = ((Number)object2).intValue();
            long l = ((Number)object3).longValue();
            return new Value((Object)(switch (this.funcNum) {
                case 12 -> new Integer(n << (int)l);
                case 13 -> new Integer(n >> (int)l);
                case 14 -> new Integer(n >>> (int)l);
                default -> throw new Impossible();
            }));
        }
        if (object2 instanceof Long || object3 instanceof Long) {
            Constable constable4;
            long l = ((Number)object2).longValue();
            long l3 = ((Number)object3).longValue();
            try {
                switch (this.funcNum) {
                    case 3: {
                        constable4 = new Long(l | l3);
                        break;
                    }
                    case 4: {
                        constable4 = new Long(l & l3);
                        break;
                    }
                    case 5: {
                        constable4 = new Long(l ^ l3);
                        break;
                    }
                    case 6: {
                        constable4 = new Boolean(l == l3);
                        break;
                    }
                    case 7: {
                        constable4 = new Boolean(l != l3);
                        break;
                    }
                    case 8: {
                        constable4 = new Boolean(l < l3);
                        break;
                    }
                    case 9: {
                        constable4 = new Boolean(l > l3);
                        break;
                    }
                    case 10: {
                        constable4 = new Boolean(l <= l3);
                        break;
                    }
                    case 11: {
                        constable4 = new Boolean(l >= l3);
                        break;
                    }
                    case 15: {
                        constable4 = new Long(l + l3);
                        break;
                    }
                    case 16: {
                        constable4 = new Long(l - l3);
                        break;
                    }
                    case 17: {
                        constable4 = new Long(l * l3);
                        break;
                    }
                    case 18: {
                        constable4 = new Long(l / l3);
                        break;
                    }
                    case 19: {
                        constable4 = new Long(l % l3);
                        break;
                    }
                    default: {
                        throw new Impossible();
                    }
                }
            }
            catch (Exception exception) {
                throw new Impossible();
            }
            return new Value((Object)constable4);
        }
        int n = ((Number)object2).intValue();
        int n2 = ((Number)object3).intValue();
        try {
            switch (this.funcNum) {
                case 3: {
                    constable = new Integer(n | n2);
                    break;
                }
                case 4: {
                    constable = new Integer(n & n2);
                    break;
                }
                case 5: {
                    constable = new Integer(n ^ n2);
                    break;
                }
                case 6: {
                    constable = new Boolean(n == n2);
                    break;
                }
                case 7: {
                    constable = new Boolean(n != n2);
                    break;
                }
                case 8: {
                    constable = new Boolean(n < n2);
                    break;
                }
                case 9: {
                    constable = new Boolean(n > n2);
                    break;
                }
                case 10: {
                    constable = new Boolean(n <= n2);
                    break;
                }
                case 11: {
                    constable = new Boolean(n >= n2);
                    break;
                }
                case 15: {
                    constable = new Integer(n + n2);
                    break;
                }
                case 16: {
                    constable = new Integer(n - n2);
                    break;
                }
                case 17: {
                    constable = new Integer(n * n2);
                    break;
                }
                case 18: {
                    constable = new Integer(n / n2);
                    break;
                }
                case 19: {
                    constable = new Integer(n % n2);
                    break;
                }
                default: {
                    throw new Impossible();
                }
            }
        }
        catch (Exception exception) {
            if (exception instanceof InvocationTargetException) {
                throw new Impossible("InvocationTargetException occured during method call: " + String.valueOf(((InvocationTargetException)exception).getTargetException()));
            }
            throw new Impossible("Exception occured during method call: " + String.valueOf(exception));
        }
        return new Value((Object)constable);
    }

    public final String toString() {
        String string = null;
        try {
            string = funcNames[this.funcNum];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        if (string == null) {
            string = "BasicFunc(<<<INVALID!>>>)";
        }
        return string;
    }

    static {
        BasicFunction.funcNames[1] = "BasicFunc(LOR)";
        BasicFunction.funcNames[2] = "BasicFunc(LAND)";
        BasicFunction.funcNames[3] = "BasicFunc(OR)";
        BasicFunction.funcNames[4] = "BasicFunc(AND)";
        BasicFunction.funcNames[5] = "BasicFunc(XOR)";
        BasicFunction.funcNames[6] = "BasicFunc(EQUAL)";
        BasicFunction.funcNames[7] = "BasicFunc(NEQUAL)";
        BasicFunction.funcNames[8] = "BasicFunc(LESS)";
        BasicFunction.funcNames[9] = "BasicFunc(GREATER)";
        BasicFunction.funcNames[10] = "BasicFunc(LESSEQUAL)";
        BasicFunction.funcNames[11] = "BasicFunc(GREATEREQUAL)";
        BasicFunction.funcNames[12] = "BasicFunc(SHL)";
        BasicFunction.funcNames[13] = "BasicFunc(SHR)";
        BasicFunction.funcNames[14] = "BasicFunc(SSHR)";
        BasicFunction.funcNames[15] = "BasicFunc(PLUS)";
        BasicFunction.funcNames[16] = "BasicFunc(MINUS)";
        BasicFunction.funcNames[17] = "BasicFunc(TIMES)";
        BasicFunction.funcNames[18] = "BasicFunc(DIVIDE)";
        BasicFunction.funcNames[19] = "BasicFunc(MOD)";
    }
}

