/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingChangeEvent;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureChangeEvent;
import CH.ifa.draw.framework.Handle;
import CH.ifa.draw.standard.AbstractFigure;
import CH.ifa.draw.standard.NullHandle;
import CH.ifa.draw.standard.RelativeLocator;
import de.renew.gui.BindingSelectionFrame;
import de.renew.gui.CPNInstanceDrawing;
import de.renew.gui.CPNSimulation;
import de.renew.gui.InstanceFigure;
import de.renew.gui.ModeReplacement;
import de.renew.gui.TransitionFigure;
import de.renew.remote.EventListener;
import de.renew.remote.ObjectAccessor;
import de.renew.remote.RemoteEventForwarder;
import de.renew.remote.RemoteEventListener;
import de.renew.remote.TransitionInstanceAccessor;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.Vector;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class TransitionInstanceFigure
extends AbstractFigure
implements InstanceFigure,
EventListener {
    public static Logger logger = Logger.getLogger(TransitionInstanceFigure.class);
    private TransitionFigure transitionFigure;
    private TransitionInstanceAccessor transitionInstance;
    private boolean afterglow = false;
    private RemoteEventForwarder forwarder;
    protected CPNInstanceDrawing drawing;
    private static final int AFTERGLOW_TIME = 100;
    private static final int COOLDOWN_TIME = 10;
    private final Runnable afterglowRunnable;
    private final ThreadPoolExecutor executor;

    public TransitionInstanceFigure(CPNInstanceDrawing cPNInstanceDrawing, TransitionFigure transitionFigure, Hashtable<Serializable, ObjectAccessor> hashtable) {
        this.drawing = cPNInstanceDrawing;
        this.transitionFigure = transitionFigure;
        this.initialize(hashtable);
        this.afterglowRunnable = new Runnable(){

            @Override
            public void run() {
                try {
                    EventQueue.invokeAndWait(() -> TransitionInstanceFigure.this.updateAfterglow(true));
                    do {
                        Thread.sleep(100L);
                    } while (TransitionInstanceFigure.this.isFiring());
                    EventQueue.invokeAndWait(() -> TransitionInstanceFigure.this.updateAfterglow(false));
                    Thread.sleep(10L);
                }
                catch (InterruptedException | InvocationTargetException exception) {
                    // empty catch block
                }
            }
        };
        this.executor = new ThreadPoolExecutor(0, 1, 10L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadPoolExecutor.DiscardPolicy());
        if (this.isFiring()) {
            this.update();
        }
    }

    private void updateAfterglow(boolean bl) {
        if (this.afterglow != bl) {
            this.afterglow = bl;
            if (this.listener() != null) {
                this.invalidate();
                this.invalidateHighlight();
                FigureChangeEvent figureChangeEvent = new FigureChangeEvent((Figure)this);
                this.listener().figureRequestUpdate(figureChangeEvent);
            }
        }
    }

    protected void initialize(Hashtable<Serializable, ObjectAccessor> hashtable) {
        if (hashtable.size() != 1) {
            logger.error((Object)("Error: There is not exactly one transition instance for the figure " + String.valueOf(this)));
            return;
        }
        this.transitionInstance = (TransitionInstanceAccessor)hashtable.elements().nextElement();
        try {
            this.forwarder = new RemoteEventForwarder((EventListener)this);
            this.transitionInstance.addRemoteEventListener((RemoteEventListener)this.forwarder);
        }
        catch (RemoteException remoteException) {
            logger.error((Object)remoteException.getMessage(), (Throwable)remoteException);
        }
    }

    public boolean isFiring() {
        boolean bl = false;
        try {
            if (this.transitionInstance != null) {
                bl = this.transitionInstance.isFiring();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return bl;
    }

    @Override
    public boolean isHighlighted() {
        return this.afterglow;
    }

    private void invalidateHighlight() {
        Figure figure = this.transitionFigure.getHighlightFigure();
        if (figure != null) {
            Rectangle rectangle = figure.displayBox();
            DrawingChangeEvent drawingChangeEvent = new DrawingChangeEvent((Drawing)this.drawing, rectangle);
            this.drawing.drawingInvalidated(drawingChangeEvent);
        }
    }

    public void update() {
        this.executor.execute(this.afterglowRunnable);
    }

    public void basicDisplayBox(Point point, Point point2) {
    }

    public Vector<Handle> handles() {
        Vector<Handle> vector = new Vector<Handle>();
        vector.addElement((Handle)new NullHandle((Figure)this, RelativeLocator.northWest()));
        vector.addElement((Handle)new NullHandle((Figure)this, RelativeLocator.northEast()));
        vector.addElement((Handle)new NullHandle((Figure)this, RelativeLocator.southWest()));
        vector.addElement((Handle)new NullHandle((Figure)this, RelativeLocator.southEast()));
        return vector;
    }

    public Rectangle displayBox() {
        return this.transitionFigure.displayBox();
    }

    protected void basicMoveBy(int n, int n2) {
    }

    public void draw(Graphics graphics) {
    }

    public boolean inspect(DrawingView drawingView, boolean bl) {
        if (bl) {
            if (this.fire()) {
                String string;
                try {
                    string = this.transitionInstance.asString();
                }
                catch (RemoteException remoteException) {
                    string = remoteException.toString();
                }
                drawingView.editor().showStatus("Transition " + string + " fired.");
            } else {
                drawingView.editor().showStatus("No binding for this transition.");
            }
        } else {
            logger.debug((Object)("Searching bindings for " + String.valueOf(this.transitionInstance) + "..."));
            BindingSelectionFrame.open(this.transitionInstance, this.getSimulation());
        }
        return true;
    }

    protected CPNSimulation getSimulation() {
        return ModeReplacement.getInstance().getSimulation();
    }

    public boolean fire() {
        boolean bl;
        CPNSimulation cPNSimulation = this.getSimulation();
        cPNSimulation.getBreakpointManager().clearLog();
        try {
            bl = this.transitionInstance.fireOneBinding();
        }
        catch (RemoteException remoteException) {
            logger.error((Object)remoteException.getMessage(), (Throwable)remoteException);
            bl = false;
        }
        cPNSimulation.simulationRefresh();
        return bl;
    }

    public void release() {
        if (this.transitionInstance != null) {
            try {
                this.transitionInstance.removeRemoteEventListener((RemoteEventListener)this.forwarder);
            }
            catch (RemoteException remoteException) {
                logger.error((Object)remoteException.getMessage(), (Throwable)remoteException);
            }
            this.transitionInstance = null;
        }
        super.release();
    }

    protected TransitionInstanceAccessor getInstance() {
        return this.transitionInstance;
    }
}

