/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import de.renew.gui.ConfigureRemoteAccessController;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

class ConfigureRemoteAccessTab
extends JPanel {
    private JPanel detailOptionsPanel;
    private JLabel serverClassLabel;
    private JTextField serverClassField;
    private JCheckBox enabledBox;
    private JLabel publicNameLabel;
    private JTextField publicNameField;
    private JLabel socketFactoryLabel;
    private JTextField socketFactoryField;
    private final ConfigureRemoteAccessController controller;

    public ConfigureRemoteAccessTab(ConfigureRemoteAccessController configureRemoteAccessController) {
        super(new BorderLayout());
        this.controller = configureRemoteAccessController;
        this.initComponents();
    }

    private void initComponents() {
        this.setName("Remote Access");
        this.enabledBox = new JCheckBox();
        this.detailOptionsPanel = new JPanel();
        this.publicNameLabel = new JLabel();
        this.publicNameField = new JTextField();
        this.serverClassLabel = new JLabel();
        this.serverClassField = new JTextField();
        this.socketFactoryLabel = new JLabel();
        this.socketFactoryField = new JTextField();
        this.enabledBox.setText("Enable remote access");
        this.enabledBox.setToolTipText("When checked, the local simulation will be open for remote access.\nYou will need a running rmiregistry on the local host.");
        this.enabledBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConfigureRemoteAccessTab.this.controller.enabledStateChanged();
            }
        });
        this.add((Component)this.enabledBox, "North");
        this.detailOptionsPanel.setLayout(new GridBagLayout());
        this.detailOptionsPanel.setBorder(new TitledBorder("Advanced options"));
        this.publicNameLabel.setText("Public name");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.detailOptionsPanel.add((Component)this.publicNameLabel, gridBagConstraints);
        this.publicNameField.setToolTipText("The simulation will be published under this name.\nThis way, independent simulation environments on one host can be distinguished.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.7;
        this.detailOptionsPanel.add((Component)this.publicNameField, gridBagConstraints);
        this.serverClassLabel.setText("Server class");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.detailOptionsPanel.add((Component)this.serverClassLabel, gridBagConstraints);
        this.serverClassField.setToolTipText("If you need a special remote server implementation, enter its full qualified classname here.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.7;
        this.detailOptionsPanel.add((Component)this.serverClassField, gridBagConstraints);
        this.socketFactoryLabel.setText("Socket factory");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        this.detailOptionsPanel.add((Component)this.socketFactoryLabel, gridBagConstraints);
        this.socketFactoryField.setToolTipText("Can only be set at startup time! If you need a special RMI socket factory, enter its full qualified classname here. Leave empty to use the default factory.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.7;
        this.detailOptionsPanel.add((Component)this.socketFactoryField, gridBagConstraints);
        this.add((Component)this.detailOptionsPanel, "Center");
    }

    public void enableDetailOptions(boolean bl) {
        this.detailOptionsPanel.setEnabled(bl);
        this.publicNameLabel.setEnabled(bl);
        this.publicNameField.setEnabled(bl);
        this.serverClassLabel.setEnabled(bl);
        this.serverClassField.setEnabled(bl);
        this.socketFactoryLabel.setEnabled(false);
        this.socketFactoryField.setEnabled(false);
    }

    public void setRemoteEnabled(boolean bl) {
        this.enabledBox.setSelected(bl);
    }

    public boolean getRemoteEnabled() {
        return this.enabledBox.isSelected();
    }

    public void setServerClass(String string) {
        this.serverClassField.setText(string);
    }

    public String getServerClass() {
        return this.serverClassField.getText();
    }

    public void setPublicName(String string) {
        this.publicNameField.setText(string);
    }

    public String getPublicName() {
        return this.publicNameField.getText();
    }

    public void setSocketFactory(String string) {
        this.socketFactoryField.setText(string);
    }

    public String getSocketFactory() {
        return this.socketFactoryField.getText();
    }
}

