/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.figures.AttributeFigure;
import CH.ifa.draw.framework.FigureChangeListener;
import CH.ifa.draw.framework.ParentFigure;
import CH.ifa.draw.io.StorableInputDrawingLoader;
import CH.ifa.draw.util.Storable;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import de.renew.gui.ArcConnection;
import de.renew.gui.CPNDrawing;
import de.renew.gui.CPNTextFigure;
import de.renew.gui.ModeReplacement;
import de.renew.gui.PatchingStorableInput;
import de.renew.gui.PlaceFigure;
import de.renew.gui.TransitionFigure;
import de.renew.gui.VirtualPlaceFigure;
import java.awt.AWTEventMulticaster;
import java.awt.Dimension;
import java.awt.Point;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.EventListener;
import java.util.Vector;

public class CPNDrawingHelper {
    public PlaceFigure createPlace() {
        PlaceFigure placeFigure = new PlaceFigure();
        Dimension dimension = PlaceFigure.defaultDimension();
        placeFigure.displayBox(new Point(0, 0), new Point((int)dimension.getWidth(), (int)dimension.getHeight()));
        return placeFigure;
    }

    public VirtualPlaceFigure createVirtualPlace(PlaceFigure placeFigure) {
        VirtualPlaceFigure virtualPlaceFigure = new VirtualPlaceFigure(placeFigure);
        Dimension dimension = PlaceFigure.defaultDimension();
        virtualPlaceFigure.displayBox(new Point(0, 0), new Point((int)dimension.getWidth(), (int)dimension.getHeight()));
        return virtualPlaceFigure;
    }

    public TransitionFigure createTransition() {
        TransitionFigure transitionFigure = new TransitionFigure();
        Dimension dimension = TransitionFigure.defaultDimension();
        transitionFigure.displayBox(new Point(0, 0), new Point((int)dimension.getWidth(), (int)dimension.getHeight()));
        return transitionFigure;
    }

    public ArcConnection createArcConnection(AttributeFigure attributeFigure, AttributeFigure attributeFigure2, int n) {
        ArcConnection arcConnection = new ArcConnection(n);
        arcConnection.startPoint(0, 0);
        arcConnection.endPoint(0, 0);
        arcConnection.connectStart(attributeFigure.connectorAt(attributeFigure.center()));
        arcConnection.connectEnd(attributeFigure2.connectorAt(attributeFigure2.center()));
        arcConnection.updateConnection();
        return arcConnection;
    }

    public ArcConnection createArcConnection(AttributeFigure attributeFigure, AttributeFigure attributeFigure2) {
        return this.createArcConnection(attributeFigure, attributeFigure2, 1);
    }

    public CPNTextFigure createNameTextFigure(String string, ParentFigure parentFigure) {
        CPNTextFigure cPNTextFigure = new CPNTextFigure(2);
        cPNTextFigure.setText(string);
        cPNTextFigure.setParent(parentFigure);
        cPNTextFigure.moveBy(0, -20);
        return cPNTextFigure;
    }

    public CPNTextFigure createInscription(String string, ParentFigure parentFigure) {
        CPNTextFigure cPNTextFigure = new CPNTextFigure(1);
        cPNTextFigure.setText(string);
        cPNTextFigure.setParent(parentFigure);
        return cPNTextFigure;
    }

    public CPNTextFigure createWeightTextFigure(ArcConnection arcConnection, int n) {
        CPNTextFigure cPNTextFigure = new CPNTextFigure(1);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("[];");
        }
        cPNTextFigure.setText(stringBuilder.toString());
        cPNTextFigure.setParent(arcConnection);
        return cPNTextFigure;
    }

    public Vector<ArcConnection> getConnectedArcs(AttributeFigure attributeFigure) {
        FigureChangeListener[] figureChangeListenerArray;
        Vector<ArcConnection> vector = new Vector<ArcConnection>();
        for (FigureChangeListener figureChangeListener : figureChangeListenerArray = (FigureChangeListener[])AWTEventMulticaster.getListeners((EventListener)attributeFigure.listener(), FigureChangeListener.class)) {
            ArcConnection arcConnection;
            if (!(figureChangeListener instanceof ArcConnection) || !(arcConnection = (ArcConnection)figureChangeListener).startFigure().equals(attributeFigure) && !arcConnection.endFigure().equals(attributeFigure)) continue;
            vector.add(arcConnection);
        }
        return vector;
    }

    public static String netAsString(CPNDrawing cPNDrawing) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        cPNDrawing.lock();
        try {
            StorableOutput storableOutput = new StorableOutput((OutputStream)byteArrayOutputStream);
            storableOutput.writeInt(11);
            storableOutput.writeStorable((Storable)cPNDrawing);
            storableOutput.close();
            cPNDrawing.clearModified();
        }
        finally {
            cPNDrawing.unlock();
        }
        return ((Object)byteArrayOutputStream).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CPNDrawing netFromString(String string, boolean bl) throws IOException {
        CPNDrawing cPNDrawing;
        if (string == null || string.trim().length() < 10) {
            return null;
        }
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
            PatchingStorableInput patchingStorableInput = new PatchingStorableInput(byteArrayInputStream, true);
            cPNDrawing = (CPNDrawing)StorableInputDrawingLoader.readStorableDrawing((StorableInput)patchingStorableInput);
            cPNDrawing.invalidate();
            if (bl) {
                ModeReplacement.getInstance().getDrawingLoader().addDrawing(cPNDrawing);
            }
        }
        finally {
            try {
                if (byteArrayInputStream != null) {
                    ((InputStream)byteArrayInputStream).close();
                }
            }
            catch (Exception exception) {}
        }
        return cPNDrawing;
    }
}

