/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.figures.LineConnection;
import CH.ifa.draw.framework.ConnectionFigure;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureChangeAdapter;
import CH.ifa.draw.framework.FigureChangeEvent;
import CH.ifa.draw.framework.FigureChangeListener;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.FilterContainer;
import CH.ifa.draw.io.SimpleFileFilter;
import CH.ifa.draw.standard.AbstractFigure;
import CH.ifa.draw.standard.CompositeFigure;
import CH.ifa.draw.standard.StandardDrawing;
import CH.ifa.draw.util.Storable;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import de.renew.gui.CPNTextFigure;
import de.renew.gui.DeclarationFigure;
import de.renew.gui.FigureWithHighlight;
import de.renew.gui.GraphLayout;
import de.renew.gui.LayoutableDrawing;
import de.renew.gui.NodeFigure;
import de.renew.gui.PlaceFigure;
import de.renew.gui.ShadowHolder;
import de.renew.gui.TransitionFigure;
import de.renew.io.RNWFileFilter;
import de.renew.shadow.ShadowNet;
import de.renew.shadow.ShadowNetElement;
import de.renew.shadow.ShadowNetSystem;
import java.awt.Dimension;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;

public class CPNDrawing
extends StandardDrawing
implements LayoutableDrawing {
    public static Logger logger = Logger.getLogger(CPNDrawing.class);
    private static FilterContainer filterContainer;
    protected transient ShadowNet shadowNet = null;
    private AbstractFigure iconFigure = null;
    private transient Hashtable<Figure, Figure> hilightMap = new Hashtable();

    public void release() {
        super.release();
        this.discardShadow();
    }

    public ShadowNet getShadow() {
        return this.shadowNet;
    }

    static CPNDrawing findDrawing(Object object) {
        if (object instanceof ShadowNetElement) {
            return (CPNDrawing)((ShadowNetElement)object).getNet().context;
        }
        return null;
    }

    public void discardShadow() {
        if (this.shadowNet != null) {
            this.shadowNet.discard();
            this.shadowNet = null;
        }
    }

    private void buildShadow(Class<?> clazz) {
        FigureEnumeration figureEnumeration = this.figures();
        while (figureEnumeration.hasMoreElements()) {
            Figure figure = figureEnumeration.nextFigure();
            if (!(figure instanceof ShadowHolder) || !clazz.isInstance(figure)) continue;
            ((ShadowHolder)figure).buildShadow(this.shadowNet);
        }
    }

    public ShadowNet buildShadow(ShadowNetSystem shadowNetSystem) {
        this.discardShadow();
        this.shadowNet = new ShadowNet(this.getName(), shadowNetSystem);
        this.shadowNet.context = this;
        this.buildShadow(DeclarationFigure.class);
        this.buildShadow(NodeFigure.class);
        this.buildShadow(LineConnection.class);
        this.buildShadow(CPNTextFigure.class);
        return this.shadowNet;
    }

    public void setIconFigure(AbstractFigure abstractFigure) {
        this.iconFigure = abstractFigure;
    }

    public Figure getIconFigure() {
        return this.iconFigure;
    }

    public Figure remove(Figure figure) {
        Figure figure2;
        if (figure == this.iconFigure) {
            this.iconFigure = null;
        }
        if (figure instanceof FigureWithHighlight && (figure2 = ((FigureWithHighlight)figure).getHighlightFigure()) != null) {
            this.hilightMap.remove(figure2);
        }
        figure2 = super.remove(figure);
        if (figure instanceof CompositeFigure) {
            this.recomputeHilightMap();
        }
        return figure2;
    }

    public void write(StorableOutput storableOutput) {
        super.write(storableOutput);
        storableOutput.writeStorable((Storable)this.iconFigure);
    }

    public void read(StorableInput storableInput) throws IOException {
        super.read(storableInput);
        if (storableInput.getVersion() >= 2) {
            try {
                this.iconFigure = (AbstractFigure)storableInput.readStorable();
            }
            catch (IOException iOException) {
                logger.error((Object)"Icon expected.");
                logger.debug((Object)"Icon expected.", (Throwable)iOException);
            }
            if (storableInput.getVersion() >= 3) {
                this.recomputeHilightMap();
            }
        }
    }

    @Override
    public synchronized void fillInGraph(GraphLayout graphLayout) {
        FigureEnumeration figureEnumeration = this.figures();
        while (figureEnumeration.hasMoreElements()) {
            Figure figure = figureEnumeration.nextFigure();
            if (figure instanceof TransitionFigure || figure instanceof PlaceFigure) {
                graphLayout.addNode(figure);
                continue;
            }
            if (!(figure instanceof ConnectionFigure)) continue;
            graphLayout.addEdge((ConnectionFigure)figure, 20);
        }
    }

    void setHighlightFigure(final FigureWithHighlight figureWithHighlight, final Figure figure) {
        Figure figure2 = figureWithHighlight.getHighlightFigure();
        if (figure2 != null) {
            this.hilightMap.remove(figure2);
        }
        figureWithHighlight.setHighlightFigure(figure);
        if (figure != null) {
            this.hilightMap.put(figure, (Figure)figureWithHighlight);
            figure.addFigureChangeListener((FigureChangeListener)new FigureChangeAdapter(){

                public void figureRemoved(FigureChangeEvent figureChangeEvent) {
                    CPNDrawing.this.setHighlightFigure(figureWithHighlight, null);
                }
            });
            figureWithHighlight.addFigureChangeListener((FigureChangeListener)new FigureChangeAdapter(){

                public void figureRemoved(FigureChangeEvent figureChangeEvent) {
                    CPNDrawing.this.hilightMap.remove(figure);
                }
            });
        }
    }

    FigureWithHighlight getFigureForHighlight(Figure figure) {
        try {
            return (FigureWithHighlight)this.hilightMap.get(figure);
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
    }

    public Dimension defaultSize() {
        return new Dimension(535, 788);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.hilightMap = new Hashtable();
        this.recomputeHilightMap();
    }

    private void recomputeHilightMap() {
        this.hilightMap.clear();
        this.addToHilightMap((CompositeFigure)this);
    }

    private void addToHilightMap(CompositeFigure compositeFigure) {
        FigureEnumeration figureEnumeration = compositeFigure.figures();
        while (figureEnumeration.hasMoreElements()) {
            Figure figure;
            Figure figure2 = figureEnumeration.nextFigure();
            if (figure2 instanceof FigureWithHighlight && (figure = ((FigureWithHighlight)figure2).getHighlightFigure()) != null) {
                this.hilightMap.put(figure, figure2);
            }
            if (!(figure2 instanceof CompositeFigure)) continue;
            this.addToHilightMap((CompositeFigure)figure2);
        }
    }

    public String getWindowCategory() {
        return "Nets";
    }

    public Figure add(Figure figure) {
        Figure figure2;
        Figure figure3 = super.add(figure);
        if (figure instanceof FigureWithHighlight && (figure2 = ((FigureWithHighlight)figure).getHighlightFigure()) != null) {
            this.hilightMap.put(figure2, figure);
        }
        if (figure instanceof CompositeFigure) {
            this.recomputeHilightMap();
        }
        return figure3;
    }

    public static FilterContainer getFilterContainer() {
        if (filterContainer == null) {
            return new FilterContainer((SimpleFileFilter)new RNWFileFilter());
        }
        return filterContainer;
    }

    public SimpleFileFilter getDefaultFileFilter() {
        return CPNDrawing.getFilterContainer().getDefaultFileFilter();
    }

    public HashSet<SimpleFileFilter> getImportFileFilters() {
        return CPNDrawing.getFilterContainer().getImportFileFilters();
    }

    public HashSet<SimpleFileFilter> getExportFileFilters() {
        return CPNDrawing.getFilterContainer().getExportFileFilters();
    }

    public String getDefaultExtension() {
        return this.getDefaultFileFilter().getExtension();
    }
}

