/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.DrawingChangeEvent;
import CH.ifa.draw.framework.DrawingChangeListener;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureChangeEvent;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.FigureWithID;
import CH.ifa.draw.framework.FilterContainer;
import CH.ifa.draw.framework.Handle;
import CH.ifa.draw.io.IFAFileFilter;
import CH.ifa.draw.io.SimpleFileFilter;
import CH.ifa.draw.standard.CompositeFigure;
import CH.ifa.draw.standard.NullHandle;
import CH.ifa.draw.standard.RelativeLocator;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import de.renew.util.Lock;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.log4j.Logger;

public class StandardDrawing
extends CompositeFigure
implements Drawing {
    public static Logger logger = Logger.getLogger(StandardDrawing.class);
    private static FilterContainer filterContainer;
    static String fgUntitled;
    private static final long serialVersionUID = -2602151437447962046L;
    private transient Vector<DrawingChangeListener> fListeners;
    private transient Lock fLock;
    private String fDrawingName = fgUntitled;
    private transient File fDrawingFilename = null;
    private transient boolean modified = false;
    private transient boolean fBackupStatus = false;
    private int drawingSerializedDataVersion = 1;
    protected transient int maxUsedID = 0;
    protected transient Hashtable<Integer, Figure> usedIDs = new Hashtable();

    public StandardDrawing() {
        this.fListeners = new Vector(2);
        this.fLock = new Lock();
    }

    @Override
    public String getName() {
        return this.fDrawingName;
    }

    @Override
    public void setName(String string) {
        this.fDrawingName = string;
    }

    public Dimension getSize() {
        return new Dimension(this.getBounds().width, this.getBounds().height);
    }

    @Override
    public File getFilename() {
        return this.fDrawingFilename;
    }

    @Override
    public void setFilename(File file) {
        this.fDrawingFilename = file;
    }

    @Override
    public boolean getBackupStatus() {
        return this.fBackupStatus;
    }

    @Override
    public void setBackupStatus(boolean bl) {
        this.fBackupStatus = bl;
    }

    @Override
    public void addDrawingChangeListener(DrawingChangeListener drawingChangeListener) {
        this.fListeners.addElement(drawingChangeListener);
    }

    @Override
    public void removeDrawingChangeListener(DrawingChangeListener drawingChangeListener) {
        this.fListeners.removeElement(drawingChangeListener);
    }

    @Override
    public Enumeration<DrawingChangeListener> drawingChangeListeners() {
        return this.fListeners.elements();
    }

    @Override
    public Figure remove(Figure figure) {
        if (figure instanceof FigureWithID) {
            this.freeID((FigureWithID)figure);
        }
        Figure figure2 = null;
        if (figure.listener() != null) {
            figure.listener().figureRequestRemove(new FigureChangeEvent(figure, null));
            figure2 = figure;
        }
        if (figure instanceof CompositeFigure) {
            this.recomputeIDCache();
        }
        return figure2;
    }

    @Override
    public void figureRequestRemove(FigureChangeEvent figureChangeEvent) {
        Figure figure = figureChangeEvent.getFigure();
        if (this.fFigures.contains(figure)) {
            this.modified = true;
            this.fFigures.removeElement(figure);
            figure.removeFromContainer(this);
            figure.release();
        } else {
            logger.error((Object)"Attempt to remove non-existing figure");
        }
    }

    @Override
    public void figureInvalidated(FigureChangeEvent figureChangeEvent) {
        this.modified = true;
        if (this.fListeners != null) {
            for (int i = 0; i < this.fListeners.size(); ++i) {
                DrawingChangeListener drawingChangeListener = this.fListeners.elementAt(i);
                drawingChangeListener.drawingInvalidated(new DrawingChangeEvent(this, figureChangeEvent.getInvalidatedRectangle()));
            }
        }
    }

    @Override
    public void figureRequestUpdate(FigureChangeEvent figureChangeEvent) {
        if (this.fListeners != null) {
            for (int i = 0; i < this.fListeners.size(); ++i) {
                DrawingChangeListener drawingChangeListener = this.fListeners.elementAt(i);
                drawingChangeListener.drawingRequestUpdate(new DrawingChangeEvent(this, null));
            }
        }
    }

    @Override
    public synchronized void checkDamage() {
        final StandardDrawing standardDrawing = this;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Enumeration<DrawingChangeListener> enumeration = StandardDrawing.this.fListeners.elements();
                while (enumeration.hasMoreElements()) {
                    DrawingChangeListener drawingChangeListener = enumeration.nextElement();
                    drawingChangeListener.drawingRequestUpdate(new DrawingChangeEvent(standardDrawing, null));
                }
            }
        });
    }

    @Override
    public Vector<Handle> handles() {
        Vector<Handle> vector = new Vector<Handle>();
        vector.addElement(new NullHandle(this, RelativeLocator.northWest()));
        vector.addElement(new NullHandle(this, RelativeLocator.northEast()));
        vector.addElement(new NullHandle(this, RelativeLocator.southWest()));
        vector.addElement(new NullHandle(this, RelativeLocator.southEast()));
        return vector;
    }

    @Override
    public Rectangle displayBox() {
        Rectangle rectangle = null;
        FigureEnumeration figureEnumeration = this.figures();
        while (figureEnumeration.hasMoreElements()) {
            Figure figure = figureEnumeration.nextFigure();
            if (!figure.isVisible()) continue;
            Rectangle rectangle2 = figure.displayBox();
            if (rectangle == null) {
                rectangle = rectangle2;
                continue;
            }
            rectangle.add(rectangle2);
        }
        if (rectangle == null) {
            return new Rectangle(0, 0, 100, 100);
        }
        return new Rectangle(rectangle.x - 10, rectangle.y - 10, rectangle.width + 20, rectangle.height + 20);
    }

    @Override
    public void basicDisplayBox(Point point, Point point2) {
    }

    @Override
    public void lock() {
        this.fLock.lock();
    }

    @Override
    public void unlock() {
        this.fLock.unlock();
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.fListeners = new Vector(2);
        this.fLock = new Lock();
        this.maxUsedID = 0;
        this.usedIDs = new Hashtable();
        this.recomputeIDCache();
    }

    @Override
    public boolean isModified() {
        return this.modified;
    }

    @Override
    public void clearModified() {
        this.modified = false;
    }

    @Override
    public Rectangle getBounds() {
        return this.displayBox();
    }

    @Override
    public Dimension defaultSize() {
        return new Dimension(430, 406);
    }

    @Override
    public void write(StorableOutput storableOutput) {
        super.write(storableOutput);
    }

    @Override
    public void read(StorableInput storableInput) throws IOException {
        super.read(storableInput);
        this.modified = false;
        this.recomputeIDCache();
    }

    @Override
    public String getWindowCategory() {
        return "JHotDrawings";
    }

    public static FilterContainer getFilterContainer() {
        if (filterContainer == null) {
            return new FilterContainer(new IFAFileFilter());
        }
        return filterContainer;
    }

    @Override
    public SimpleFileFilter getDefaultFileFilter() {
        return StandardDrawing.getFilterContainer().getDefaultFileFilter();
    }

    @Override
    public HashSet<SimpleFileFilter> getImportFileFilters() {
        return StandardDrawing.getFilterContainer().getImportFileFilters();
    }

    @Override
    public HashSet<SimpleFileFilter> getExportFileFilters() {
        return StandardDrawing.getFilterContainer().getExportFileFilters();
    }

    @Override
    public String getDefaultExtension() {
        return this.getDefaultFileFilter().getExtension();
    }

    @Override
    public void init() {
    }

    @Override
    public Drawing add(Drawing drawing) {
        FigureEnumeration figureEnumeration = drawing.figures();
        while (figureEnumeration.hasMoreElements()) {
            Figure figure = (Figure)figureEnumeration.nextElement();
            this.add(figure);
        }
        return drawing;
    }

    @Override
    public Drawing add(Drawing drawing, int n, int n2) {
        FigureEnumeration figureEnumeration = drawing.figures();
        while (figureEnumeration.hasMoreElements()) {
            Figure figure = (Figure)figureEnumeration.nextElement();
            this.add(figure);
            figure.moveBy(n, n2);
        }
        return drawing;
    }

    @Override
    public boolean isStorable() {
        return true;
    }

    @Override
    public Figure add(Figure figure) {
        if (figure instanceof FigureWithID) {
            if (this.maxUsedID == 0) {
                this.recomputeIDCache();
            }
            this.checkAndAssignID((FigureWithID)figure);
        }
        Figure figure2 = super.add(figure);
        if (figure instanceof CompositeFigure) {
            this.recomputeIDCache();
        }
        return figure2;
    }

    private void checkAndAssignID(FigureWithID figureWithID) {
        int n;
        int n2 = n = figureWithID.getID();
        FigureWithID figureWithID2 = (FigureWithID)this.usedIDs.get(n);
        if (figureWithID2 != null && figureWithID2 != figureWithID) {
            n2 = 0;
        }
        if (n2 == 0) {
            n2 = this.newUniqueID();
            figureWithID.setID(n2);
        }
        this.usedIDs.put(n2, figureWithID);
    }

    private int newUniqueID() {
        ++this.maxUsedID;
        if (this.usedIDs.containsKey(this.maxUsedID)) {
            boolean bl = false;
            while (this.usedIDs.containsKey(this.maxUsedID)) {
                ++this.maxUsedID;
                if (this.maxUsedID != Integer.MIN_VALUE) continue;
                this.maxUsedID = 1;
                if (bl) {
                    throw new RuntimeException("Maximum numnber of figures exeeded.");
                }
                bl = true;
            }
        }
        return this.maxUsedID;
    }

    protected void recomputeIDCache() {
        Vector<Figure> vector = new Vector<Figure>();
        this.usedIDs.clear();
        this.addToIDCache(this, vector);
        Enumeration<Figure> enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.checkAndAssignID((FigureWithID)enumeration.nextElement());
        }
    }

    private void addToIDCache(CompositeFigure compositeFigure, Vector<Figure> vector) {
        FigureEnumeration figureEnumeration = compositeFigure.figures();
        while (figureEnumeration.hasMoreElements()) {
            Figure figure = figureEnumeration.nextFigure();
            if (figure instanceof FigureWithID) {
                int n = ((FigureWithID)figure).getID();
                if (n == 0) {
                    vector.addElement(figure);
                    continue;
                }
                FigureWithID figureWithID = (FigureWithID)this.usedIDs.get(n);
                if (figureWithID == null || figureWithID == figure) {
                    this.usedIDs.put(n, figure);
                    if (n <= this.maxUsedID) continue;
                    this.maxUsedID = n;
                    continue;
                }
                vector.addElement(figure);
                continue;
            }
            if (!(figure instanceof CompositeFigure)) continue;
            this.addToIDCache((CompositeFigure)figure, vector);
        }
    }

    public void assignID(FigureWithID figureWithID, int n) {
        FigureWithID figureWithID2 = (FigureWithID)this.usedIDs.get(n);
        if (figureWithID2 != null && figureWithID2 != figureWithID) {
            throw new IllegalArgumentException("The id is already in use!");
        }
        this.usedIDs.remove(figureWithID.getID());
        figureWithID.setID(n);
        this.usedIDs.put(n, figureWithID);
    }

    private void freeID(FigureWithID figureWithID) {
        Integer n = figureWithID.getID();
        if (this.usedIDs.get(n) == figureWithID) {
            this.usedIDs.remove(n);
        }
    }

    public FigureWithID getFigureWithID(int n) {
        return (FigureWithID)this.usedIDs.get(n);
    }

    static {
        fgUntitled = "untitled";
    }
}

