/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.StringTokenizer;

public class MultiLineLabel
extends Component {
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    protected String label;
    protected int margin_width;
    protected int margin_height;
    protected int alignment;
    protected int num_lines;
    protected String[] lines;
    protected int[] line_widths;
    protected int max_width;
    protected int line_height;
    protected int line_ascent;
    protected boolean measured = false;

    public MultiLineLabel(String string, int n, int n2, int n3) {
        this.label = string;
        this.margin_width = n;
        this.margin_height = n2;
        this.alignment = n3;
        this.newLabel();
    }

    public MultiLineLabel(String string, int n, int n2) {
        this(string, n, n2, 0);
    }

    public MultiLineLabel(String string, int n) {
        this(string, 10, 10, n);
    }

    public MultiLineLabel(String string) {
        this(string, 10, 10, 0);
    }

    public MultiLineLabel() {
        this("");
    }

    public void setLabel(String string) {
        this.label = string;
        this.newLabel();
        this.measured = false;
        this.repaint();
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.measured = false;
        this.repaint();
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        this.repaint();
    }

    public void setAlignment(int n) {
        this.alignment = n;
        this.repaint();
    }

    public void setMarginWidth(int n) {
        this.margin_width = n;
        this.repaint();
    }

    public void setMarginHeight(int n) {
        this.margin_height = n;
        this.repaint();
    }

    public String getLabel() {
        return this.label;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public int getMarginWidth() {
        return this.margin_width;
    }

    public int getMarginHeight() {
        return this.margin_height;
    }

    @Override
    public Dimension getPreferredSize() {
        if (!this.measured) {
            this.measure();
        }
        return new Dimension(this.max_width + 2 * this.margin_width, this.num_lines * this.line_height + 2 * this.margin_height);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (!this.measured) {
            this.measure();
        }
        int n = this.line_ascent + (dimension.height - this.num_lines * this.line_height) / 2;
        int n2 = 0;
        while (n2 < this.num_lines) {
            graphics.drawString(this.lines[n2], switch (this.alignment) {
                default -> this.margin_width;
                case 1 -> (dimension.width - this.line_widths[n2]) / 2;
                case 2 -> dimension.width - this.margin_width - this.line_widths[n2];
            }, n);
            ++n2;
            n += this.line_height;
        }
    }

    protected synchronized void newLabel() {
        StringTokenizer stringTokenizer = new StringTokenizer(this.label, "\n");
        this.num_lines = stringTokenizer.countTokens();
        this.lines = new String[this.num_lines];
        this.line_widths = new int[this.num_lines];
        for (int i = 0; i < this.num_lines; ++i) {
            this.lines[i] = stringTokenizer.nextToken();
        }
    }

    protected synchronized void measure() {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        this.line_height = fontMetrics.getHeight();
        this.line_ascent = fontMetrics.getAscent();
        this.max_width = 0;
        for (int i = 0; i < this.num_lines; ++i) {
            this.line_widths[i] = fontMetrics.stringWidth(this.lines[i]);
            if (this.line_widths[i] <= this.max_width) continue;
            this.max_width = this.line_widths[i];
        }
        this.measured = true;
    }
}

