/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.PieFigure;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.standard.AbstractHandle;
import CH.ifa.draw.util.Geom;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import org.freehep.graphicsio.VectorGraphicsIO;

class PieAngleHandle
extends AbstractHandle {
    private double angle;
    private PieFigure pieFig;
    private int angleKind;

    public PieAngleHandle(PieFigure pieFigure, int n) {
        super(pieFigure);
        this.pieFig = pieFigure;
        this.angleKind = n;
    }

    @Override
    public void invokeStart(int n, int n2, DrawingView drawingView) {
        super.invokeStart(n, n2, drawingView);
        this.angle = this.pieFig.getAngle(this.angleKind);
    }

    @Override
    public void invokeStep(MouseEvent mouseEvent, int n, int n2, int n3, int n4, DrawingView drawingView) {
        Rectangle rectangle = this.pieFig.displayBox();
        Point point = new Point(n, n2);
        Point point2 = new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
        double d = point.equals(point2) ? Math.PI : Geom.pointToAngle(rectangle, point);
        this.angle = PieFigure.normalizeAngle(-Math.toDegrees(d));
        if (mouseEvent.isControlDown()) {
            this.angle = Math.round(this.angle / 15.0) * 15L % 360L;
        }
        this.pieFig.setAngle(this.angleKind, this.angle);
    }

    @Override
    public Point locate() {
        Rectangle rectangle = this.pieFig.displayBox();
        this.angle = this.pieFig.getAngle(this.angleKind);
        double d = -Math.toRadians(this.angle);
        return Geom.ovalAngleToPoint(rectangle, d);
    }

    @Override
    public void draw(Graphics graphics) {
        Rectangle rectangle = this.displayBox();
        graphics.setColor(Color.yellow);
        if (graphics instanceof VectorGraphicsIO) {
            graphics.fillOval(rectangle.x + 1, rectangle.y + 1, rectangle.width - 1, rectangle.height - 1);
        } else {
            graphics.fillOval(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        graphics.setColor(Color.black);
        graphics.drawOval(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }
}

