/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.contrib;

import CH.ifa.draw.contrib.PolygonFigure;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.standard.AbstractHandle;
import CH.ifa.draw.util.Geom;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

class PolygonScaleHandle
extends AbstractHandle {
    private Point fOrigin = null;
    private Point fCurrent = null;
    private Polygon fOrigPoly = null;

    public PolygonScaleHandle(PolygonFigure polygonFigure) {
        super(polygonFigure);
    }

    @Override
    public void invokeStart(int n, int n2, DrawingView drawingView) {
        super.invokeStart(n, n2, drawingView);
        this.fOrigPoly = ((PolygonFigure)this.owner()).getPolygon();
        this.fOrigin = this.getOrigin();
        this.fCurrent = new Point(this.fOrigin.x, this.fOrigin.y);
    }

    @Override
    public void invokeStep(MouseEvent mouseEvent, int n, int n2, int n3, int n4, DrawingView drawingView) {
        int n5 = n - n3;
        int n6 = n2 - n4;
        boolean bl = true;
        boolean bl2 = true;
        this.fCurrent = new Point(this.fOrigin.x + n5, this.fOrigin.y + n6);
        if (mouseEvent.isControlDown()) {
            bl2 = false;
        } else if (mouseEvent.isShiftDown()) {
            bl = false;
        }
        ((PolygonFigure)this.owner()).scaleRotate(this.fOrigin, this.fOrigPoly, this.fCurrent, bl, bl2);
        drawingView.selectionInvalidateHandles();
    }

    @Override
    public void invokeEnd(int n, int n2, int n3, int n4, DrawingView drawingView) {
        super.invokeEnd(n, n2, n3, n4, drawingView);
        this.fOrigPoly = null;
        this.fOrigin = null;
        this.fCurrent = null;
    }

    @Override
    public Point locate() {
        if (this.fCurrent != null) {
            return this.fCurrent;
        }
        return this.getOrigin();
    }

    Point getOrigin() {
        Point point = ((PolygonFigure)this.owner()).outermostPoint();
        Point point2 = ((PolygonFigure)this.owner()).center();
        double d = Geom.length(point.x, point.y, point2.x, point2.y);
        if (d == 0.0) {
            return new Point(point.x - 4, point.y + 4);
        }
        double d2 = 8.0 / d;
        if (d2 > 1.0) {
            return new Point((point.x * 3 + point2.x) / 4, (point.y * 3 + point2.y) / 4);
        }
        return new Point((int)((double)point.x * (1.0 - d2) + (double)point2.x * d2), (int)((double)point.y * (1.0 - d2) + (double)point2.y * d2));
    }

    @Override
    public void draw(Graphics graphics) {
        Rectangle rectangle = this.displayBox();
        graphics.setColor(Color.yellow);
        graphics.fillOval(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.setColor(Color.black);
        graphics.drawOval(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }
}

