/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui.logging;

import CH.ifa.draw.util.AWTSynchronizedUpdate;
import de.renew.gui.logging.RepositoryChangeListener;
import de.renew.gui.logging.StepTrace;
import de.renew.gui.logging.StepTraceChangeListener;
import de.renew.gui.logging.StepTraceRemoveRequest;
import de.renew.gui.logging.StepTraceRepository;
import java.awt.EventQueue;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class RepositoryChangeBuffer
implements RepositoryChangeListener {
    private static Logger logger = Logger.getLogger(RepositoryChangeBuffer.class);
    private static final long MIN_DELAY = 15L;
    private Map<StepTrace, BufferedEvent> buffer = new HashMap<StepTrace, BufferedEvent>();
    private AWTSynchronizedUpdate updater;
    protected Set<StepTraceChangeListener> listeners = new HashSet<StepTraceChangeListener>();

    public RepositoryChangeBuffer() {
        this.updater = new AWTSynchronizedUpdate(15L, new Runnable(){

            @Override
            public void run() {
                RepositoryChangeBuffer.this.fireBulkUpdate();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireBulkUpdate() {
        Map<StepTrace, BufferedEvent> map;
        assert (EventQueue.isDispatchThread()) : "RepositoryChangeBuffer.fireBulkUpdate must be executed in the event thread.";
        Object object = this;
        synchronized (object) {
            map = this.buffer;
            this.buffer = new HashMap<StepTrace, BufferedEvent>();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(String.valueOf(this) + ": preparing bulk update with " + map.size() + " events."));
        }
        object = new TreeMap(new StepTraceComparator());
        object.putAll(map);
        for (BufferedEvent bufferedEvent : object.values()) {
            switch (bufferedEvent.kind) {
                case ADD: {
                    this.fireStepTraceAdded(bufferedEvent.repository, bufferedEvent.step);
                    break;
                }
                case CHANGE: {
                    this.fireStepTraceChanged(bufferedEvent.step);
                    break;
                }
                case REMOVE: {
                    this.fireStepTraceRemoved(bufferedEvent.repository, bufferedEvent.step);
                }
            }
        }
    }

    public void addStepTraceChangeListener(StepTraceChangeListener stepTraceChangeListener) {
        this.listeners.add(stepTraceChangeListener);
    }

    public void removeStepTraceChangeListener(StepTraceChangeListener stepTraceChangeListener) {
        this.listeners.remove(stepTraceChangeListener);
    }

    protected void fireStepTraceChanged(StepTrace stepTrace) {
        StepTraceChangeListener[] stepTraceChangeListenerArray = this.listeners.toArray(new StepTraceChangeListener[0]);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)(String.valueOf(this) + ": Sending change for step " + String.valueOf(stepTrace) + " to " + stepTraceChangeListenerArray.length + " listeners."));
        }
        for (int i = 0; i < stepTraceChangeListenerArray.length; ++i) {
            stepTraceChangeListenerArray[i].stepTraceChanged(stepTrace);
        }
    }

    protected void fireStepTraceAdded(StepTraceRepository stepTraceRepository, StepTrace stepTrace) {
        StepTraceChangeListener[] stepTraceChangeListenerArray = this.listeners.toArray(new StepTraceChangeListener[0]);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)(String.valueOf(this) + ": Sending add for step " + String.valueOf(stepTrace) + " to " + stepTraceChangeListenerArray.length + " listeners."));
        }
        for (int i = 0; i < stepTraceChangeListenerArray.length; ++i) {
            if (!(stepTraceChangeListenerArray[i] instanceof RepositoryChangeListener)) continue;
            ((RepositoryChangeListener)stepTraceChangeListenerArray[i]).stepTraceAdded(stepTraceRepository, stepTrace);
        }
    }

    protected void fireStepTraceRemoved(StepTraceRepository stepTraceRepository, StepTrace stepTrace) {
        StepTraceChangeListener[] stepTraceChangeListenerArray = this.listeners.toArray(new StepTraceChangeListener[0]);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)(String.valueOf(this) + ": Sending remove for step " + String.valueOf(stepTrace) + " to " + stepTraceChangeListenerArray.length + " listeners."));
        }
        for (int i = 0; i < stepTraceChangeListenerArray.length; ++i) {
            if (!(stepTraceChangeListenerArray[i] instanceof RepositoryChangeListener)) continue;
            ((RepositoryChangeListener)stepTraceChangeListenerArray[i]).stepTraceRemoved(stepTraceRepository, stepTrace);
        }
    }

    @Override
    public synchronized void stepTraceChanged(StepTrace stepTrace) {
        if (this.buffer.containsKey(stepTrace)) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)(String.valueOf(this) + ": Discarding change " + String.valueOf(stepTrace)));
            }
        } else {
            this.buffer.put(stepTrace, new BufferedEvent(BufferedEvent.Kind.CHANGE, stepTrace, null));
            if (this.updater != null) {
                this.updater.scheduleUpdate();
            }
        }
    }

    @Override
    public synchronized void stepTraceAdded(StepTraceRepository stepTraceRepository, StepTrace stepTrace) {
        if (this.buffer.containsKey(stepTrace)) {
            logger.warn((Object)(String.valueOf(this) + ": Add event is not the first event for step " + String.valueOf(stepTrace)));
        }
        this.buffer.put(stepTrace, new BufferedEvent(BufferedEvent.Kind.ADD, stepTrace, stepTraceRepository));
        if (this.updater != null) {
            this.updater.scheduleUpdate();
        }
    }

    @Override
    public synchronized void stepTraceRemoved(StepTraceRepository stepTraceRepository, StepTrace stepTrace) {
        if (this.buffer.containsKey(stepTrace) && this.buffer.get((Object)stepTrace).kind == BufferedEvent.Kind.ADD) {
            this.buffer.remove(stepTrace);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)(String.valueOf(this) + ": Discarding add/remove pair for step " + String.valueOf(stepTrace)));
            }
        } else {
            this.buffer.put(stepTrace, new BufferedEvent(BufferedEvent.Kind.REMOVE, stepTrace, stepTraceRepository));
            if (this.updater != null) {
                this.updater.scheduleUpdate();
            }
        }
    }

    @Override
    public void stepTraceRemoveRequest(StepTraceRemoveRequest stepTraceRemoveRequest) {
    }

    protected void stopBuffer() {
        this.updater = null;
    }

    private static class StepTraceComparator
    implements Comparator<StepTrace> {
        private StepTraceComparator() {
        }

        @Override
        public int compare(StepTrace stepTrace, StepTrace stepTrace2) {
            long l = stepTrace.getStepIdentifier() != null && stepTrace.getStepIdentifier().getComponents() != null && stepTrace.getStepIdentifier().getComponents().length > 0 ? stepTrace.getStepIdentifier().getComponents()[0] : 0L;
            long l2 = stepTrace2.getStepIdentifier() != null && stepTrace2.getStepIdentifier().getComponents() != null && stepTrace2.getStepIdentifier().getComponents().length > 0 ? stepTrace2.getStepIdentifier().getComponents()[0] : 0L;
            return (int)Math.signum(l - l2);
        }
    }

    private static class BufferedEvent {
        public final Kind kind;
        public final StepTrace step;
        public final StepTraceRepository repository;

        public BufferedEvent(Kind kind, StepTrace stepTrace, StepTraceRepository stepTraceRepository) {
            this.kind = kind;
            this.step = stepTrace;
            this.repository = stepTraceRepository;
        }

        public static enum Kind {
            ADD,
            CHANGE,
            REMOVE;

        }
    }
}

