/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui.logging;

import de.renew.gui.ComponentRenderer;
import de.renew.gui.JComponentCellEditor;
import de.renew.gui.logging.LoggerTableModel;
import de.renew.gui.logging.LoggingController;
import de.renew.gui.logging.TableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.apache.log4j.Logger;

public class LoggingFrame
extends JFrame {
    public static Logger logger = Logger.getLogger(LoggingFrame.class);
    private LoggingController controller;
    private JTable loggerTable;
    private JScrollPane scrollPane;
    private JComboBox loggerComboBox;
    private JCheckBox updateCheckBox;

    public LoggingFrame(LoggingController loggingController, String[] stringArray) {
        this.controller = loggingController;
        this.setTitle("Simulation log messages");
        this.setDefaultCloseOperation(2);
        this.initGUI(stringArray);
        this.pack();
        this.setVisible(true);
    }

    public void initGUI(String[] stringArray) {
        try {
            this.loggerComboBox = new JComboBox<String>(stringArray);
            this.loggerComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                    String string = (String)jComboBox.getSelectedItem();
                    LoggingFrame.this.controller.changeLogger(string);
                }
            });
            this.scrollPane = new JScrollPane();
            this.loggerTable = new JTable(new TableModel(true)){

                @Override
                public TableCellRenderer getCellRenderer(int n, int n2) {
                    TableColumn tableColumn = this.getColumnModel().getColumn(n2);
                    TableCellRenderer tableCellRenderer = tableColumn.getCellRenderer();
                    if (tableCellRenderer == null) {
                        Object object;
                        Class<?> clazz = this.getColumnClass(n2);
                        if (clazz.equals(Object.class) && (object = this.getValueAt(n, n2)) != null) {
                            clazz = this.getValueAt(n, n2).getClass();
                        }
                        tableCellRenderer = this.getDefaultRenderer(clazz);
                    }
                    return tableCellRenderer;
                }

                @Override
                public TableCellEditor getCellEditor(int n, int n2) {
                    TableColumn tableColumn = this.getColumnModel().getColumn(n2);
                    TableCellEditor tableCellEditor = tableColumn.getCellEditor();
                    if (tableCellEditor == null) {
                        Object object;
                        Class<?> clazz = this.getColumnClass(n2);
                        if (clazz.equals(Object.class) && (object = this.getValueAt(n, n2)) != null) {
                            clazz = this.getValueAt(n, n2).getClass();
                        }
                        tableCellEditor = this.getDefaultEditor(clazz);
                    }
                    return tableCellEditor;
                }
            };
            TableCellRenderer tableCellRenderer = this.loggerTable.getDefaultRenderer(JComponent.class);
            this.loggerTable.setDefaultRenderer(JComponent.class, (TableCellRenderer)new ComponentRenderer(tableCellRenderer));
            TableCellEditor tableCellEditor = this.loggerTable.getDefaultEditor(JComponent.class);
            this.loggerTable.setDefaultEditor(JComponent.class, (TableCellEditor)new JComponentCellEditor(tableCellEditor, null));
            this.setName("Simulation Trace");
            BorderLayout borderLayout = new BorderLayout();
            this.getContentPane().setLayout(borderLayout);
            this.getContentPane().add((Component)this.loggerComboBox, "North");
            this.getContentPane().add((Component)this.scrollPane, "Center");
            this.scrollPane.add(this.loggerTable);
            this.scrollPane.setViewportView(this.loggerTable);
            this.updateCheckBox = new JCheckBox("permanent update");
            this.updateCheckBox.setSelected(true);
            this.updateCheckBox.addActionListener(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    LoggingFrame.this.controller.setPermanentUpdate(LoggingFrame.this.updateCheckBox.isSelected());
                }
            });
            this.getContentPane().add((Component)this.updateCheckBox, "South");
        }
        catch (Exception exception) {
            logger.error((Object)exception.getMessage(), (Throwable)exception);
        }
    }

    public ComboBoxModel getComboBoxModel() {
        return this.loggerComboBox.getModel();
    }

    public void setTableModel(LoggerTableModel loggerTableModel) {
        if (loggerTableModel != null) {
            this.loggerTable.setModel(loggerTableModel);
            loggerTableModel.addTableModelListener(new TableModelListenerImpl());
            this.updateRowHeights();
        }
    }

    public LoggerTableModel getTableModel() {
        return (LoggerTableModel)this.loggerTable.getModel();
    }

    public String getSelectedLoggerName() {
        return (String)this.loggerComboBox.getSelectedItem();
    }

    public void updateRowHeights() {
        TableModel tableModel = (TableModel)this.loggerTable.getModel();
        for (int i = 0; i < tableModel.getRowCount(); ++i) {
            Object object = tableModel.getValueAt(i, 0);
            if (!(object instanceof JComponent)) continue;
            JComponent jComponent = (JComponent)object;
            this.loggerTable.setRowHeight(i, jComponent.getPreferredSize().height);
        }
    }

    public void updateRowHeight(int n) {
        TableModel tableModel = (TableModel)this.loggerTable.getModel();
        Object object = tableModel.getValueAt(n, 0);
        if (object instanceof JComponent) {
            JComponent jComponent = (JComponent)object;
            this.loggerTable.setRowHeight(n, jComponent.getPreferredSize().height);
        }
    }

    private class TableModelListenerImpl
    implements TableModelListener {
        private TableModelListenerImpl() {
        }

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            if (tableModelEvent.getType() == 1 || tableModelEvent.getType() == 0) {
                for (int i = tableModelEvent.getFirstRow(); i <= tableModelEvent.getLastRow(); ++i) {
                    LoggingFrame.this.updateRowHeight(i);
                }
            }
        }
    }
}

