/*
 * Decompiled with CFR 0.152.
 */
package de.renew.navigator.models;

import de.renew.navigator.models.BackgroundTask;
import de.renew.navigator.models.Model;
import de.renew.navigator.models.SearchFilter;
import de.renew.navigator.models.TreeElement;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public final class NavigatorFileTree
extends Model {
    protected List<SearchFilter> activeFileFilters = new ArrayList<SearchFilter>();
    protected SearchFilter textSearch;
    protected final List<BackgroundTask> backgroundTasks = new LinkedList<BackgroundTask>();

    public List<SearchFilter> getActiveFileFilters() {
        return this.activeFileFilters;
    }

    public void setActiveFileFilters(List<SearchFilter> list) {
        this.activeFileFilters = list;
        this.setChanged();
    }

    public List<TreeElement> getTreeRoots() {
        return this.elements;
    }

    public void activateFileFilter(SearchFilter searchFilter) {
        this.activeFileFilters.add(searchFilter);
        this.setChanged();
    }

    public void deactivateFileFilter(SearchFilter searchFilter) {
        if (!this.activeFileFilters.remove(searchFilter)) {
            throw new IllegalArgumentException(String.format("The file filter was not activated yet: %s", searchFilter));
        }
        this.setChanged();
    }

    public void deactivateFileFilter(String string) {
        SearchFilter searchFilter = this.getFileFilterByName(string);
        if (searchFilter == null) {
            return;
        }
        this.deactivateFileFilter(searchFilter);
    }

    public SearchFilter getFileFilterByName(String string) {
        for (SearchFilter searchFilter : this.activeFileFilters) {
            if (!searchFilter.getName().equals(string)) continue;
            return searchFilter;
        }
        return null;
    }

    public void clearTreeRoots() {
        this.elements.clear();
        this.setChanged();
    }

    public void expandAll() {
        for (TreeElement treeElement : this.elements) {
            treeElement.expandAll();
        }
    }

    public void clear() {
        this.activeFileFilters.clear();
        this.elements.clear();
    }

    public List<BackgroundTask> getBackgroundTasks() {
        return this.backgroundTasks;
    }

    public void addBackgroundTask(BackgroundTask backgroundTask) {
        this.backgroundTasks.add(backgroundTask);
        this.setChanged();
    }

    public void removeBackgroundTask(BackgroundTask backgroundTask) {
        this.backgroundTasks.remove(backgroundTask);
        this.setChanged();
    }

    public SearchFilter getTextSearch() {
        return this.textSearch;
    }

    public void setTextSearch(SearchFilter searchFilter) {
        this.textSearch = searchFilter;
        this.setChanged();
    }
}

