/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.framework.ChildFigure;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.Handle;
import CH.ifa.draw.framework.PartialSelectableFigure;
import CH.ifa.draw.framework.Tool;
import CH.ifa.draw.standard.AbstractTool;
import CH.ifa.draw.standard.ChildDragTracker;
import CH.ifa.draw.standard.DragTracker;
import CH.ifa.draw.standard.HandleTracker;
import CH.ifa.draw.standard.SelectAreaTracker;
import de.renew.util.StringUtil;
import java.awt.Desktop;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.log4j.Logger;

public class SelectionTool
extends AbstractTool {
    public static Logger logger = Logger.getLogger(SelectionTool.class);
    private Tool fChild = null;
    private Tool fLastChild = null;
    private DrawingView fFreezedView = null;

    public SelectionTool(DrawingEditor drawingEditor) {
        super(drawingEditor);
    }

    @Override
    public void mouseDown(MouseEvent mouseEvent, int n, int n2) {
        if (this.fChild != null) {
            return;
        }
        try {
            boolean bl;
            boolean bl2 = bl = (mouseEvent.getModifiers() & 0xC) != 0;
            if (this.fLastChild != null && mouseEvent.getClickCount() == 2 && !bl) {
                this.fChild = this.fLastChild;
                this.fLastChild = null;
            } else {
                if (this.fFreezedView == null) {
                    this.fFreezedView = this.view();
                    this.fFreezedView.freezeView();
                }
                Handle handle = null;
                if (!bl && this.view().selectionCount() == 1) {
                    handle = this.view().findHandle(n, n2);
                }
                if (handle != null) {
                    this.fLastChild = this.fChild = this.createHandleTracker(this.fEditor, handle);
                } else {
                    this.fLastChild = null;
                    Figure figure = this.drawing().findFigure(n, n2);
                    if (figure == null && (handle = this.view().findHandle(n, n2)) != null) {
                        figure = handle.owner();
                    }
                    boolean bl3 = false;
                    if (figure != null) {
                        bl3 = true;
                        if (figure instanceof PartialSelectableFigure && !this.view().selection().contains(figure)) {
                            bl3 = false;
                            PartialSelectableFigure partialSelectableFigure = (PartialSelectableFigure)((Object)figure);
                            if (partialSelectableFigure.isModifierSelectable() && mouseEvent.isAltDown()) {
                                bl3 = true;
                            } else if (partialSelectableFigure.isSelectableInRegion(n, n2)) {
                                bl3 = true;
                            }
                        }
                    }
                    if (bl3) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Click-on-figure: " + String.valueOf(figure)));
                        }
                        if (mouseEvent.isControlDown()) {
                            if (!bl) {
                                this.openTargetLocation(figure);
                            }
                        } else {
                            if (mouseEvent.getClickCount() >= 2 && !bl) {
                                figure.inspect(this.view(), false);
                                return;
                            }
                            if (bl && this.alternateInspectFigure(figure)) {
                                return;
                            }
                            this.fChild = this.createDragTracker(this.fEditor, figure);
                        }
                    } else {
                        if (!mouseEvent.isShiftDown()) {
                            this.view().clearSelection();
                        }
                        this.fChild = this.createAreaTracker(this.fEditor);
                    }
                }
            }
            if (this.fChild != null) {
                if (this.fChild instanceof DragTracker || this.fChild instanceof ChildDragTracker || this.fChild instanceof SelectAreaTracker) {
                    this.fChild.mouseDown(mouseEvent, n, n2);
                } else {
                    this.fChild.mouseDown(mouseEvent, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        }
        catch (RuntimeException runtimeException) {
            if (this.fFreezedView != null) {
                this.fFreezedView.unfreezeView();
                this.fFreezedView = null;
            }
            throw runtimeException;
        }
        catch (Error error) {
            if (this.fFreezedView != null) {
                this.fFreezedView.unfreezeView();
                this.fFreezedView = null;
            }
            throw error;
        }
    }

    private void openTargetLocation(Figure figure) {
        block11: {
            Object object = figure.getAttribute("targetLocation");
            if (object != null) {
                try {
                    URI uRI = new URI((String)object);
                    try {
                        String string = uRI.getScheme();
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)(SelectionTool.class.getSimpleName() + ": Trying to open: Scheme | Host | Path = " + string + " | " + uRI.getHost() + " | " + uRI.getPath()));
                        }
                        if (string == null && !DrawPlugin.getGui().canOpen(uRI)) {
                            string = "file";
                            uRI = new URI(string, uRI.getHost(), uRI.getPath(), uRI.getFragment());
                        }
                        if (string == null) {
                            URI uRI2 = new File(this.drawing().getFilename().getCanonicalPath()).toURI();
                            URI uRI3 = uRI2.resolve(uRI);
                            DrawPlugin.getGui().openOrLoadDrawing(new File(uRI3.getPath()));
                            break block11;
                        }
                        if ("sim".equals(string)) {
                            this.simAccess(uRI);
                            break block11;
                        }
                        Desktop.getDesktop().browse(uRI);
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        URI uRI4 = new File(this.drawing().getFilename().getCanonicalPath()).toURI();
                        String string = StringUtil.getPath((String)uRI4.getPath());
                        Desktop.getDesktop().open(new File(string, (String)object));
                    }
                    catch (IOException iOException) {
                        logger.error((Object)("Could not find file: " + uRI.getPath() + " " + iOException.getMessage()));
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)(SelectionTool.class.getSimpleName() + ": "), (Throwable)iOException);
                        }
                    }
                }
                catch (Exception exception) {
                    logger.error((Object)("An error occured during file access (malformed URL?): " + exception.getMessage()));
                    if (!logger.isDebugEnabled()) break block11;
                    logger.debug((Object)(SelectionTool.class.getSimpleName() + ": "), (Throwable)exception);
                }
            }
        }
    }

    @Override
    public void mouseDrag(MouseEvent mouseEvent, int n, int n2) {
        if (this.fChild != null) {
            this.fChild.mouseDrag(mouseEvent, n, n2);
            this.fLastChild = null;
        }
    }

    @Override
    public void mouseUp(MouseEvent mouseEvent, int n, int n2) {
        if (this.fFreezedView != null) {
            this.fFreezedView.unfreezeView();
            this.fFreezedView = null;
        }
        if (this.fChild != null) {
            this.fChild.mouseUp(mouseEvent, n, n2);
        }
        this.fChild = null;
    }

    protected Tool createHandleTracker(DrawingEditor drawingEditor, Handle handle) {
        return new HandleTracker(drawingEditor, handle);
    }

    protected Tool createDragTracker(DrawingEditor drawingEditor, Figure figure) {
        if (figure instanceof ChildFigure) {
            return new ChildDragTracker(drawingEditor, (ChildFigure)figure);
        }
        return new DragTracker(drawingEditor, figure);
    }

    protected Tool createAreaTracker(DrawingEditor drawingEditor) {
        return new SelectAreaTracker(drawingEditor);
    }

    protected boolean alternateInspectFigure(Figure figure) {
        return figure.inspect(this.view(), true);
    }

    @Override
    public void draw(Graphics graphics) {
        if (this.fChild != null) {
            this.fChild.draw(graphics);
        }
    }

    @Override
    public void deactivate() {
        if (this.fFreezedView != null) {
            this.fFreezedView.unfreezeView();
            this.fFreezedView = null;
        }
        super.deactivate();
    }
}

