/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.contrib;

import CH.ifa.draw.contrib.TriangleFigure;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.standard.AbstractHandle;
import CH.ifa.draw.util.Geom;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;

class TriangleRotationHandle
extends AbstractHandle {
    private Point fCenter = null;

    public TriangleRotationHandle(TriangleFigure triangleFigure) {
        super(triangleFigure);
    }

    @Override
    public void invokeStart(int n, int n2, DrawingView drawingView) {
        super.invokeStart(n, n2, drawingView);
        Rectangle rectangle = this.owner().displayBox();
        this.fCenter = new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
    }

    @Override
    public void invokeStep(int n, int n2, int n3, int n4, DrawingView drawingView) {
        double d = Math.atan2(n2 - this.fCenter.y, n - this.fCenter.x);
        ((TriangleFigure)this.owner()).rotate(d);
    }

    @Override
    public void invokeEnd(int n, int n2, int n3, int n4, DrawingView drawingView) {
        super.invokeEnd(n, n2, n3, n4, drawingView);
        this.fCenter = null;
    }

    @Override
    public Point locate() {
        return this.getOrigin();
    }

    Point getOrigin() {
        Polygon polygon = ((TriangleFigure)this.owner()).outline();
        Point point = new Point(polygon.xpoints[0], polygon.ypoints[0]);
        Point point2 = this.owner().center();
        double d = Geom.length(point.x, point.y, point2.x, point2.y);
        if (d == 0.0) {
            return new Point(point.x - 4, point.y + 4);
        }
        double d2 = 8.0 / d;
        if (d2 > 1.0) {
            return new Point((point.x * 3 + point2.x) / 4, (point.y * 3 + point2.y) / 4);
        }
        return new Point((int)((double)point.x * (1.0 - d2) + (double)point2.x * d2), (int)((double)point.y * (1.0 - d2) + (double)point2.y * d2));
    }

    @Override
    public void draw(Graphics graphics) {
        Rectangle rectangle = this.displayBox();
        graphics.setColor(Color.yellow);
        graphics.fillOval(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.setColor(Color.black);
        graphics.drawOval(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }
}

