/*
 * Decompiled with CFR 0.152.
 */
package de.renew.lola;

import de.renew.plugin.PluginProperties;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class LolaHelper {
    private static Logger logger = Logger.getLogger(LolaHelper.class);
    public static final String markingKey = "ANALYSE MARKING";
    public static final String placeKey = "ANALYSE PLACE";
    public static final String transitionKey = "ANALYSE TRANSITION";
    public static final String stateFormulaKey = "STATE PREDICATE FORMULA";
    public static final String CTLFormulaKey = "CTL FORMULA";
    public static final String formulaKey = "FORMULA";
    public static final String assertKey = "ASSERT";
    public static final String markingFileName = "Marking";
    public static final String CTLFormulaFileName = "CTL";
    public static final String stateFormulaFileName = "StatePredicate";
    public static final String transitionFileName = "Transition";
    public static final String placeFileName = "Place";
    public static final String livepropFileName = "Liveprop";
    public static final String dotCommand = "graph2dot";
    public static final String graphCommand = "lola -M";
    public static final String markingCommand = "lola-reach-mark";
    public static final String placeCommand = "lola-bounded-place";
    public static final String transitionCommand = "lola-dead-transition";
    public static final String CTLCommand = "lola-model-checking";
    public static final String statePredicateCommand = "lola-state-predicate";
    public static final String livepropCommand = "lola-liveprop";
    public static final String nethomeStateCommand = "lola-home-state";
    public static final String netReversibleCommand = "lola-reversible";
    public static final String netDeadlockCommand = "lola-deadlock";
    public static final String netBoundedCommand = "lola-bounded-net";
    public static HashMap<String, String> taskFilenameMap = new HashMap();
    public static HashMap<String, String> taskCommandMap;

    public static File findTmpDir() {
        File file;
        String string = PluginProperties.getUserProperties().getProperty("de.renew.lola.tmpdir");
        if (string != null) {
            file = new File(string);
        } else {
            string = System.getProperty("java.io.tmpdir");
            if (string != null) {
                file = new File(string);
            } else {
                logger.error((Object)"System property java.io.tmpdir not found, please provide de.renew.lola.tmpdir in your user properties");
                return null;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"[Lola] tmpDir successfully set");
        }
        return file;
    }

    protected static Boolean ctlp(String string) {
        List<String> list = Arrays.asList("always", "until", "eventually", "nextstep", "expath", "allpath");
        for (String string2 : list) {
            if (!string.toLowerCase().contains(string2)) continue;
            return true;
        }
        return false;
    }

    static {
        taskFilenameMap.put(markingKey, markingFileName);
        taskFilenameMap.put(placeKey, placeFileName);
        taskFilenameMap.put(transitionKey, transitionFileName);
        taskFilenameMap.put(stateFormulaKey, stateFormulaFileName);
        taskFilenameMap.put(CTLFormulaKey, CTLFormulaFileName);
        taskCommandMap = new HashMap();
        taskCommandMap.put(markingFileName, markingCommand);
        taskCommandMap.put(placeFileName, placeCommand);
        taskCommandMap.put(transitionFileName, transitionCommand);
        taskCommandMap.put(CTLFormulaFileName, CTLCommand);
        taskCommandMap.put(stateFormulaFileName, statePredicateCommand);
        taskCommandMap.put(livepropFileName, livepropCommand);
    }
}

