/*
 * Decompiled with CFR 0.152.
 */
package de.renew.imagenetdiff;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.io.StatusDisplayer;
import CH.ifa.draw.util.ColorMap;
import CH.ifa.draw.util.DrawingHelper;
import de.renew.imagenetdiff.AbstractDiffCommand;
import de.renew.imagenetdiff.EPSDiffCommand;
import de.renew.imagenetdiff.ImageNetDiffPlugin;
import de.renew.io.exportFormats.PNGExportFormat;
import de.renew.plugin.PluginManager;
import de.renew.util.StringUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import org.apache.log4j.Logger;

public class PNGDiffCommand
extends AbstractDiffCommand {
    static final String IMAGE_EXTENSION = ".png";
    static final Logger logger = Logger.getLogger(PNGDiffCommand.class);

    public PNGDiffCommand() {
        super("Simple PNG Diff");
        this.setImageExtension(IMAGE_EXTENSION);
    }

    @Override
    public File doDiff(StatusDisplayer statusDisplayer, Drawing drawing, Drawing drawing2, boolean bl) {
        if (drawing != null && drawing2 != null) {
            Process process;
            String string;
            String string2;
            int n;
            int n2;
            Drawing drawing3;
            Object object;
            block27: {
                PluginManager pluginManager = PluginManager.getInstance();
                boolean bl2 = false;
                if (pluginManager != null && (object = (ImageNetDiffPlugin)pluginManager.getPluginByName("ImageNetDiff")) != null) {
                    bl2 = object.getProperties().getBoolProperty("de.renew.imagenetdiff.background");
                }
                if (!bl2) {
                    try {
                        object = PNGDiffCommand.removeBackground(drawing);
                        drawing3 = PNGDiffCommand.removeBackground(drawing2);
                    }
                    catch (Exception exception) {
                        logger.error((Object)exception.getMessage());
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)(PNGDiffCommand.class.getSimpleName() + ": " + String.valueOf(exception)));
                        }
                        object = drawing;
                        drawing3 = drawing2;
                        bl2 = true;
                    }
                } else {
                    object = drawing;
                    drawing3 = drawing2;
                }
                PNGExportFormat pNGExportFormat = new PNGExportFormat();
                String string3 = object.getName();
                String string4 = drawing3.getName();
                if (logger.isInfoEnabled()) {
                    logger.info((Object)(PNGDiffCommand.class.getSimpleName() + ": fileName1 " + string3));
                    logger.info((Object)(PNGDiffCommand.class.getSimpleName() + ": fileName2 " + string4));
                }
                Rectangle rectangle = object.getBounds();
                Rectangle rectangle2 = drawing3.getBounds();
                n2 = Math.max(rectangle.width + rectangle.x, rectangle2.width + rectangle2.x);
                n = Math.max(rectangle.height + rectangle.y, rectangle2.height + rectangle2.y);
                Rectangle rectangle3 = new Rectangle(0, 0, n2, n);
                File file = null;
                File file2 = null;
                try {
                    file = File.createTempFile("export-", string3 + this.getImageExtension());
                    file2 = File.createTempFile("export-", string4 + this.getImageExtension());
                }
                catch (IOException iOException) {
                    logger.error((Object)iOException.getMessage());
                    logger.debug((Object)iOException.getMessage(), (Throwable)iOException);
                }
                if (logger.isInfoEnabled()) {
                    logger.info((Object)(PNGDiffCommand.class.getSimpleName() + ": tempFile1 " + file.getAbsolutePath()));
                }
                try {
                    pNGExportFormat.internalExport(object, file, rectangle3, false);
                    pNGExportFormat.internalExport(drawing3, file2, rectangle3, false);
                }
                catch (Exception exception) {
                    logger.error((Object)exception.getMessage());
                    logger.debug((Object)exception.getMessage(), (Throwable)exception);
                }
                String string5 = StringUtil.stripFilenameExtension((String)file.getAbsolutePath());
                String string6 = StringUtil.stripFilenameExtension((String)file2.getAbsolutePath());
                string2 = string5 + "-diff";
                string = string5 + "-diff" + this.getImageExtension();
                if (bl2) {
                    this.exchangeColor(string5, 10, "white", "white");
                    this.exchangeColor(string6, 10, "white", "white");
                    if (object.getFilename() != null && (object.getFilename().getName().endsWith(".aip") || object.getFilename().getName().endsWith(".rnw"))) {
                        logger.debug((Object)"Doing AIP/RNW conversion.");
                        this.exchangeColor(string5, 10, "lightgray", "white");
                        this.exchangeColor(string5, 10, "lightgreen", "white");
                        this.exchangeColor(string6, 10, "lightgray", "white");
                        this.exchangeColor(string6, 10, "lightgreen", "white");
                        this.exchangeColor(string5, 10, "seagreen1", "white");
                        this.exchangeColor(string6, 10, "seagreen1", "white");
                        this.exchangeColor(string5, 10, "yellow", "white");
                        this.exchangeColor(string6, 10, "yellow", "white");
                    }
                }
                process = null;
                try {
                    process = Runtime.getRuntime().exec("compare -alpha Remove " + string6 + this.getImageExtension() + " " + string5 + this.getImageExtension() + " " + string);
                }
                catch (Exception exception) {
                    logger.error((Object)("Error while executing imagemagick compare: " + exception.getMessage()));
                    if (!logger.isDebugEnabled()) break block27;
                    logger.debug((Object)(PNGDiffCommand.class.getSimpleName() + ": " + exception.getMessage()), (Throwable)exception);
                }
            }
            int n3 = 0;
            if (process != null) {
                try {
                    n3 = process.waitFor();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)(EPSDiffCommand.class.getSimpleName() + ": process' exit code = " + n3));
                    }
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            this.exchangeColor(string2, 10, "#d81030", "green");
            File file = new File(string);
            if (!file.exists()) {
                statusDisplayer.showStatus("Could not create diff image. ImageMagick installed?");
            } else if (!bl) {
                BufferedImage bufferedImage;
                JFrame jFrame;
                block28: {
                    final ImageNetDiffPlugin imageNetDiffPlugin = (ImageNetDiffPlugin)PluginManager.getInstance().getPluginByName("ImageNetDiff");
                    imageNetDiffPlugin.addBlock();
                    jFrame = new JFrame("Diff Image: " + object.getName() + " (red)  and " + drawing3.getName() + " (green)");
                    jFrame.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowClosing(WindowEvent windowEvent) {
                            jFrame.dispose();
                            imageNetDiffPlugin.removeBlock();
                        }
                    });
                    bufferedImage = null;
                    try {
                        bufferedImage = ImageIO.read(file);
                    }
                    catch (IOException iOException) {
                        logger.error((Object)iOException.getMessage());
                        if (!logger.isDebugEnabled()) break block28;
                        logger.debug((Object)(EPSDiffCommand.class.getName() + ": "), (Throwable)iOException);
                    }
                }
                ImageComponent imageComponent = new ImageComponent(bufferedImage, n2, n);
                JScrollPane jScrollPane = new JScrollPane(imageComponent);
                jFrame.add(jScrollPane);
                jFrame.setSize(new Dimension(n2, n));
                jFrame.pack();
                jFrame.setVisible(true);
            } else {
                statusDisplayer.showStatus("Diff image created successfully. Name: " + file.getName());
            }
            return file;
        }
        statusDisplayer.showStatus("Operation canceled.");
        return null;
    }

    private static Drawing removeBackground(Drawing drawing) throws Exception {
        Drawing drawing2 = DrawingHelper.cloneDrawing((Drawing)drawing);
        FigureEnumeration figureEnumeration = drawing2.figures();
        while (figureEnumeration.hasMoreElements()) {
            Figure figure = (Figure)figureEnumeration.nextElement();
            figure.setAttribute("FillColor", (Object)ColorMap.NONE);
        }
        return drawing2;
    }

    public static class ImageComponent
    extends Component {
        BufferedImage img;
        Dimension dim;

        public ImageComponent(BufferedImage bufferedImage, int n, int n2) {
            this.img = bufferedImage;
            this.dim = new Dimension(n, n2);
        }

        @Override
        public Dimension getPreferredSize() {
            return this.dim;
        }

        @Override
        public void paint(Graphics graphics) {
            graphics.drawImage(this.img, 0, 0, null);
        }
    }
}

