/*
 * Decompiled with CFR 0.152.
 */
package de.renew.io.exportFormats;

import CH.ifa.draw.framework.Drawing;
import CH.ifa.draw.io.EPSFileFilter;
import CH.ifa.draw.io.exportFormats.ExportFormatAbstract;
import CH.ifa.draw.util.ColorMap;
import de.renew.io.exportFormats.ExportPlugin;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.File;
import java.util.Properties;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;
import org.freehep.graphicsbase.util.UserProperties;
import org.freehep.graphicsio.AbstractVectorGraphicsIO;
import org.freehep.graphicsio.ps.AbstractPSGraphics2D;
import org.freehep.graphicsio.ps.EPSGraphics2D;

public class EPSExportFormat
extends ExportFormatAbstract {
    public static final Logger logger = Logger.getLogger(EPSExportFormat.class);

    public EPSExportFormat() {
        super("EPS", (FileFilter)new EPSFileFilter());
    }

    public boolean canExportNto1() {
        return false;
    }

    public File export(Drawing drawing, File file) throws Exception {
        Rectangle rectangle = drawing.getBounds();
        return this.internalExport(drawing, file, rectangle, true);
    }

    public File internalExport(Drawing drawing, File file, Rectangle rectangle, boolean bl) throws Exception {
        File file2 = null;
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        Dimension dimension = new Dimension(n3, n4);
        EPSGraphics2D ePSGraphics2D = new EPSGraphics2D(file, dimension);
        UserProperties userProperties = new UserProperties();
        userProperties.setProperty(AbstractPSGraphics2D.PAGE_MARGINS, new Insets(0, 0, 0, 0));
        userProperties.setProperty(AbstractPSGraphics2D.FIT_TO_PAGE, true);
        String string = "shapes";
        ExportPlugin exportPlugin = ExportPlugin.getCurrent();
        if (exportPlugin != null) {
            string = exportPlugin.getEpsFontHandling();
        }
        if ("embed".equals(string)) {
            userProperties.setProperty(AbstractPSGraphics2D.EMBED_FONTS, true);
            userProperties.setProperty(AbstractVectorGraphicsIO.TEXT_AS_SHAPES, false);
        } else if ("none".equals(string)) {
            userProperties.setProperty(AbstractPSGraphics2D.EMBED_FONTS, false);
            userProperties.setProperty(AbstractVectorGraphicsIO.TEXT_AS_SHAPES, false);
        } else {
            if (!"shapes".equals(string)) {
                logger.warn((Object)("Unknown EPS font handling configured: " + string));
            }
            userProperties.setProperty(AbstractPSGraphics2D.EMBED_FONTS, false);
            userProperties.setProperty(AbstractVectorGraphicsIO.TEXT_AS_SHAPES, true);
        }
        if (exportPlugin != null) {
            userProperties.setProperty(AbstractPSGraphics2D.TRANSPARENT, exportPlugin.getEpsTransparency());
        } else {
            userProperties.setProperty(AbstractPSGraphics2D.TRANSPARENT, true);
        }
        userProperties.setProperty(AbstractVectorGraphicsIO.CLIP, true);
        userProperties.setProperty(AbstractPSGraphics2D.PAGE_SIZE, AbstractPSGraphics2D.CUSTOM_PAGE_SIZE);
        userProperties.setProperty(AbstractPSGraphics2D.CUSTOM_PAGE_SIZE, dimension);
        userProperties.setProperty(AbstractPSGraphics2D.BACKGROUND, false);
        userProperties.setProperty(AbstractPSGraphics2D.BACKGROUND_COLOR, ColorMap.NONE);
        ePSGraphics2D.setProperties((Properties)userProperties);
        ePSGraphics2D.startExport();
        if (bl) {
            ePSGraphics2D.translate(n * -1, n2 * -1);
        }
        ePSGraphics2D.clipRect(n, n2, n3, n4);
        drawing.draw((Graphics)ePSGraphics2D);
        ePSGraphics2D.endExport();
        file2 = file;
        assert (file2 != null) : "Failure in EPSExportFormat: result == null";
        return file2;
    }

    public File export(Drawing[] drawingArray, File file) throws Exception {
        File file2 = null;
        assert (file2 != null) : "Failure in EPSExportFormat: result == null";
        return file2;
    }

    public boolean canExportDrawing(Drawing drawing) {
        boolean bl = false;
        bl = true;
        return bl;
    }

    public int getShortCut() {
        return 69;
    }
}

