/*
 * Decompiled with CFR 0.152.
 */
package de.renew.database.entitylayer;

import de.renew.database.entitylayer.Attribute;
import de.renew.database.entitylayer.Entity;
import de.renew.database.entitylayer.SQLDialect;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;

public class MsqlDialect
extends SQLDialect {
    @Override
    protected void setUniquePrimaryKeyValueAfterInsert(Connection connection, Entity entity, Hashtable<String, Object> hashtable) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setUniquePrimaryKeyValueBeforeInsert(Connection connection, Entity entity, Hashtable<String, Object> hashtable) throws SQLException {
        Attribute[] attributeArray = entity.getPrimaryKey();
        if (attributeArray.length != 1) {
            throw new IllegalStateException("Auto-set primary key works only on tables with exactly one primary key attribute.\n" + entity.getTableName() + " is not such a table.");
        }
        Class<?> clazz = entity.getClass();
        synchronized (clazz) {
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("select _seq from ");
                stringBuffer.append(entity.getTableName());
                statement = connection.createStatement();
                resultSet = statement.executeQuery(stringBuffer.toString());
                if (resultSet.next()) {
                    entity.setValue(attributeArray[0].getName(), new Integer(resultSet.getInt(1)));
                }
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                    resultSet = null;
                }
                if (statement != null) {
                    statement.close();
                    statement = null;
                }
            }
        }
    }
}

