/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui.pnml.parser;

import CH.ifa.draw.figures.TextFigure;
import de.renew.gui.pnml.converter.NetConverter;
import de.renew.gui.pnml.parser.ElementParser;
import de.renew.gui.pnml.parser.GraphicParser;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class AnnotationParser
extends ElementParser {
    private static Logger logger = Logger.getLogger(AnnotationParser.class);
    private String _text;
    private int _offSetX = 0;
    private int _offSetY = 0;

    public AnnotationParser(Element element, NetConverter netConverter) {
        super(element, netConverter);
    }

    @Override
    protected void doParse() {
        Node node;
        NodeList nodeList = this.getElement().getElementsByTagName("text");
        if (nodeList.getLength() == 0) {
            nodeList = this.getElement().getElementsByTagName("value");
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            node = (Text)element.getFirstChild();
            if (node == null) continue;
            this._text = node.getData();
        }
        NodeList nodeList2 = this.getElement().getElementsByTagName("graphics");
        for (int i = 0; i < nodeList2.getLength(); ++i) {
            node = (Element)nodeList2.item(i);
            GraphicParser graphicParser = new GraphicParser((Element)node, this.getNetConverter());
            graphicParser.parse();
            this._offSetX = graphicParser.offsetX();
            this._offSetY = graphicParser.offsetY();
        }
    }

    public TextFigure getFigure() {
        NetConverter netConverter = this.getNetConverter();
        TextFigure textFigure = netConverter.convertAnnotationToTextFigure(this.getElement());
        if (this._text == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(AnnotationParser.class.getSimpleName() + ": PMNL text figure without text ignored: " + textFigure.getClass().getSimpleName()));
            }
            return null;
        }
        textFigure.setText(this._text);
        textFigure.moveBy(this._offSetX, this._offSetY);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(AnnotationParser.class.getSimpleName() + ": PMNL text figure detected: " + textFigure.getClass().getSimpleName() + " " + textFigure.getText()));
        }
        return textFigure;
    }
}

