/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import de.renew.shadow.DefaultShadowNetLoader;
import de.renew.util.PathEntry;
import de.renew.util.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractListModel;

public class NetpathModel
extends AbstractListModel {
    private List<PathEntry> paths;

    public NetpathModel(String string) {
        PathEntry[] pathEntryArray = StringUtil.canonizePaths((String[])StringUtil.splitPaths((String)string));
        this.paths = new ArrayList<PathEntry>(pathEntryArray.length + 5);
        for (int i = 0; i < pathEntryArray.length; ++i) {
            this.paths.add(pathEntryArray[i]);
        }
    }

    public String asPath() {
        return DefaultShadowNetLoader.asPathString((PathEntry[])this.paths.toArray(new PathEntry[this.paths.size()]));
    }

    @Override
    public int getSize() {
        return this.paths.size();
    }

    @Override
    public Object getElementAt(int n) {
        PathEntry pathEntry = this.paths.get(n);
        StringBuffer stringBuffer = new StringBuffer();
        if (pathEntry.isClasspathRelative) {
            stringBuffer.append("CLASSPATH");
            if (!"".equals(pathEntry.path)) {
                stringBuffer.append(File.separator);
            }
        }
        stringBuffer.append(pathEntry.path);
        return stringBuffer.toString();
    }

    public void add(int n, PathEntry pathEntry) {
        this.paths.add(n, pathEntry);
        this.fireIntervalAdded(this, n, n);
    }

    public void add(PathEntry pathEntry) {
        int n = this.paths.size();
        this.add(n, pathEntry);
    }

    public void set(int n, PathEntry pathEntry) {
        this.paths.remove(n);
        this.paths.add(n, pathEntry);
        this.fireContentsChanged(this, n, n);
    }

    public PathEntry get(int n) {
        return this.paths.get(n);
    }

    public PathEntry remove(int n) {
        PathEntry pathEntry = this.paths.remove(n);
        this.fireIntervalRemoved(this, n, n);
        return pathEntry;
    }

    public PathEntry[] removeAll(int[] nArray) {
        int n;
        if (nArray == null || nArray.length == 0) {
            return new PathEntry[0];
        }
        ArrayList<PathEntry> arrayList = new ArrayList<PathEntry>(this.paths.size());
        for (n = 0; n < nArray.length; ++n) {
            arrayList.add(this.paths.get(nArray[n]));
        }
        n = nArray[nArray.length - 1];
        int n2 = nArray[nArray.length - 1] + 1;
        for (int i = nArray.length - 1; i >= 0; --i) {
            this.paths.remove(nArray[i]);
            if (nArray[i] != n2 - 1) {
                this.fireIntervalRemoved(this, n2, n);
                n = nArray[i];
            }
            n2 = nArray[i];
        }
        this.fireIntervalRemoved(this, n2, n);
        return arrayList.toArray(new PathEntry[arrayList.size()]);
    }

    public void addAll(int n, PathEntry[] pathEntryArray) {
        this.paths.addAll(n, Arrays.asList(pathEntryArray));
        this.fireIntervalAdded(this, n, n + pathEntryArray.length - 1);
    }
}

