/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.KeyListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.log4j.Logger;

public class FloatingTextField {
    public static Logger logger = Logger.getLogger(FloatingTextField.class);
    private Rectangle minimum;
    protected JScrollPane scrollPane;
    protected JTextArea fEditWidget = new JTextArea(1, 10);
    private Container fContainer;

    public FloatingTextField() {
        this.fEditWidget.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                FloatingTextField.this.updateOverlay();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                FloatingTextField.this.updateOverlay();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                FloatingTextField.this.updateOverlay();
            }
        });
        this.scrollPane = new JScrollPane(this.fEditWidget, 21, 31);
        this.scrollPane.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.minimum = null;
    }

    protected void updateOverlay() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Dimension dimension = FloatingTextField.this.fEditWidget.getPreferredSize();
                if (FloatingTextField.this.minimum != null) {
                    FloatingTextField.this.scrollPane.setBounds(FloatingTextField.this.minimum.x, FloatingTextField.this.minimum.y, (dimension.width > FloatingTextField.this.minimum.width ? dimension.width : FloatingTextField.this.minimum.width) + 5, (dimension.height > FloatingTextField.this.minimum.height ? dimension.height : FloatingTextField.this.minimum.height) + 5);
                }
                FloatingTextField.this.scrollPane.repaint();
                FloatingTextField.this.scrollPane.validate();
            }
        });
    }

    public void createOverlay(Container container, Rectangle rectangle, Font font) {
        this.minimum = rectangle;
        this.fContainer = container;
        this.fContainer.add((Component)this.scrollPane, 0);
        if (font != null) {
            this.fEditWidget.setFont(font);
        }
        this.scrollPane.setLocation(rectangle.x, rectangle.y);
        this.scrollPane.repaint();
        this.scrollPane.validate();
        this.scrollPane.setVisible(true);
        this.fEditWidget.selectAll();
        this.fEditWidget.requestFocus();
        this.updateOverlay();
    }

    public void endOverlay() {
        this.fContainer.requestFocus();
        if (this.fEditWidget == null) {
            return;
        }
        this.scrollPane.setVisible(false);
        this.fContainer.remove(this.scrollPane);
    }

    public String getText() {
        return this.fEditWidget.getText();
    }

    public void setText(String string) {
        this.fEditWidget.setText(string);
    }

    public void setCaretPosition(int n, int n2) {
        int n3 = FloatingTextField.position(this.fEditWidget.getText(), n, n2);
        this.fEditWidget.select(n3, n3);
        this.fEditWidget.setCaretPosition(n3);
    }

    public void select(int n, int n2, int n3, int n4) {
        int n5 = FloatingTextField.position(this.fEditWidget.getText(), n, n2);
        int n6 = FloatingTextField.position(this.fEditWidget.getText(), n3, n4);
        this.fEditWidget.select(n5, n6);
    }

    private static int position(String string, int n, int n2) {
        int n3 = 0;
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        while (--n > 0) {
            try {
                String string2 = bufferedReader.readLine();
                n3 += string2.length() + 1;
            }
            catch (IOException iOException) {
                logger.error((Object)iOException.getMessage(), (Throwable)iOException);
            }
        }
        return n3 + n2 - 1;
    }

    public void addKeyListener(KeyListener keyListener) {
        this.fEditWidget.addKeyListener(keyListener);
    }
}

