/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureWithID;
import CH.ifa.draw.framework.SnapshotHistory;
import CH.ifa.draw.standard.NullDrawingEditor;
import CH.ifa.draw.util.Command;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import java.util.stream.Collectors;

public class UndoRedoCommand
extends Command {
    private Mode mode;

    public UndoRedoCommand(String string, Mode mode) {
        super(string);
        this.mode = mode;
    }

    private DrawingEditor getEditor() {
        DrawPlugin drawPlugin = DrawPlugin.getCurrent();
        return drawPlugin == null ? NullDrawingEditor.INSTANCE : drawPlugin.getDrawingEditor();
    }

    @Override
    public boolean isExecutable() {
        if (!super.isExecutable()) {
            return false;
        }
        if (this.getEditor() == NullDrawingEditor.INSTANCE) {
            return false;
        }
        SnapshotHistory snapshotHistory = null;
        switch (this.mode) {
            case UNDO: {
                snapshotHistory = this.getEditor().getUndoRedoManager().getUndoHistory(this.getEditor().drawing());
                break;
            }
            case REDO: {
                snapshotHistory = this.getEditor().getUndoRedoManager().getRedoHistory(this.getEditor().drawing());
            }
        }
        return snapshotHistory != null && !snapshotHistory.isEmpty();
    }

    @Override
    public void execute() {
        if (this.isExecutable()) {
            Vector<Figure> vector = this.getEditor().view().selection();
            List list = vector.stream().filter(FigureWithID.class::isInstance).map(FigureWithID.class::cast).map(figureWithID -> figureWithID.getID()).collect(Collectors.toList());
            this.getEditor().toolDone();
            switch (this.mode) {
                case UNDO: {
                    this.getEditor().getUndoRedoManager().restoreUndoSnapshot(this.getEditor().drawing());
                    break;
                }
                case REDO: {
                    this.getEditor().getUndoRedoManager().restoreRedoSnapshot(this.getEditor().drawing());
                }
            }
            Vector vector2 = Collections.list(this.getEditor().drawing().figures()).stream().filter(FigureWithID.class::isInstance).map(FigureWithID.class::cast).filter(figureWithID -> list.contains(figureWithID.getID())).collect(Collectors.toCollection(Vector::new));
            if (vector.size() == vector2.size()) {
                this.getEditor().view().addToSelectionAll(vector2);
            }
            this.getEditor().selectionChanged(this.getEditor().view());
        }
    }

    public static enum Mode {
        UNDO,
        REDO;

    }
}

