/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.PolyLineFigure;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.standard.UndoableTool;
import java.awt.event.MouseEvent;

public class ScribbleTool
extends UndoableTool {
    private PolyLineFigure fScribble;
    private int fLastX;
    private int fLastY;

    public ScribbleTool(DrawingEditor drawingEditor) {
        super(drawingEditor);
    }

    @Override
    public void activate() {
        super.activate();
        this.fScribble = null;
    }

    @Override
    public void deactivate() {
        if (this.fScribble != null && (this.fScribble.size().width < 4 || this.fScribble.size().height < 4)) {
            this.drawing().remove(this.fScribble);
            this.noChangesMade();
        }
        this.fScribble = null;
        super.deactivate();
    }

    private void point(int n, int n2) {
        if (this.fScribble == null) {
            this.fScribble = new PolyLineFigure(n, n2);
            this.view().add(this.fScribble);
            this.changesMade();
        } else if (this.fLastX != n || this.fLastY != n2) {
            this.fScribble.addPoint(n, n2);
        }
        this.fLastX = n;
        this.fLastY = n2;
    }

    @Override
    public void mouseDown(MouseEvent mouseEvent, int n, int n2) {
        if (mouseEvent.getClickCount() >= 2) {
            this.editor().toolDone();
        } else {
            this.point(n, n2);
        }
    }

    @Override
    public void mouseDrag(MouseEvent mouseEvent, int n, int n2) {
        if (this.fScribble != null) {
            this.point(n, n2);
        }
    }
}

